/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.command.executor;

import com.blibli.oss.backend.command.Command;
import com.blibli.oss.backend.command.executor.CommandExecutor;
import com.blibli.oss.backend.command.interceptor.CommandInterceptor;
import com.blibli.oss.backend.command.interceptor.InterceptorUtil;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Mono;

public class DefaultCommandExecutor
implements CommandExecutor,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommandExecutor.class);
    private Validator validator;
    private ApplicationContext applicationContext;
    private List<CommandInterceptor> commandInterceptors;

    public void afterPropertiesSet() {
        this.commandInterceptors = InterceptorUtil.getCommandInterceptors(this.applicationContext);
    }

    @Override
    public <R, T> Mono<T> execute(Class<? extends Command<R, T>> commandClass, R request) {
        return Mono.fromCallable(() -> (Command)this.applicationContext.getBean(commandClass)).doOnNext(command -> this.validateRequestIfNeeded(request, (Command)command)).flatMap(command -> this.doExecute((Command)command, request));
    }

    private <R, T> void validateRequestIfNeeded(R request, Command<R, T> command) {
        if (command.validateRequest()) {
            this.validateAndThrownIfInvalid(request);
        }
    }

    private <R> void validateAndThrownIfInvalid(R request) throws ConstraintViolationException {
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    private <R, T> Mono<T> doExecute(Command<R, T> command, R request) {
        return InterceptorUtil.fireBefore(this.commandInterceptors, command, request).switchIfEmpty(this.doExecuteCommand(request, command));
    }

    private <R, T> Mono<T> doExecuteCommand(R request, Command<R, T> command) {
        return command.execute(request).doOnSuccess(response -> InterceptorUtil.fireAfterSuccess(this.commandInterceptors, command, request, response).subscribe()).doOnError(throwable -> InterceptorUtil.fireAfterFailed(this.commandInterceptors, command, request, throwable).subscribe()).onErrorResume(throwable -> command.fallback((Throwable)throwable, request));
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

