/*
 * Decompiled with CFR 0.152.
 */
package com.gdn.data.migration.postgre;

import com.gdn.data.migration.core.DataMigrationAutoConfigurer;
import com.gdn.data.migration.core.DataMigrationProperties;
import com.gdn.data.migration.postgre.PostgreConfiguration;
import com.gdn.data.migration.postgre.PostgreInternal;
import com.gdn.data.migration.postgre.PostgreService;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.postgresql.ds.PGPoolingDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DataMigrationAutoConfigurer.class})
@EnableConfigurationProperties(value={PostgreConfiguration.class, DataMigrationProperties.class})
public class PostgreAutoConfigurer {
    @Bean
    @Autowired
    public PGPoolingDataSource pgPoolingDataSource(PostgreConfiguration configuration) {
        PGPoolingDataSource dataSource = new PGPoolingDataSource();
        dataSource.setUser(configuration.getUsername());
        dataSource.setPassword(configuration.getPassword());
        dataSource.setServerName(configuration.getHost());
        dataSource.setPortNumber(configuration.getPort().intValue());
        dataSource.setDatabaseName(configuration.getDatabase());
        return dataSource;
    }

    @Bean
    @Autowired
    public PostgreService postgreService(PGPoolingDataSource dataSource) {
        DSLContext context = DSL.using((DataSource)dataSource, (SQLDialect)SQLDialect.POSTGRES);
        return new PostgreService(context);
    }

    @Bean
    @Autowired
    public PostgreInternal postgreInternal(PostgreService postgreService, DataMigrationProperties dataMigrationProperties) {
        return new PostgreInternal(postgreService, dataMigrationProperties);
    }
}

