/*
 * Decompiled with CFR 0.152.
 */
package com.gdn.data.migration.postgre;

import com.gdn.data.migration.core.DataMigrationProperties;
import com.gdn.data.migration.core.Internal;
import com.gdn.data.migration.postgre.PostgreService;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class PostgreInternal
implements Internal {
    private PostgreService postgreService;
    private DataMigrationProperties dataMigrationProperties;

    public PostgreInternal(PostgreService postgreService, DataMigrationProperties dataMigrationProperties) {
        this.postgreService = postgreService;
        this.dataMigrationProperties = dataMigrationProperties;
    }

    public void ensureVersion() {
        this.postgreService.getContext().createTableIfNotExists(this.dataMigrationProperties.getVersionTableName()).column("id", SQLDataType.VARCHAR).column("value", SQLDataType.BIGINT).constraints(new Constraint[]{DSL.constraint((String)"pk_blibli_migration_version").primaryKey(new String[]{"id"})}).execute();
        if (this.postgreService.getContext().fetchCount(DSL.table((Name)DSL.name((String[])new String[]{this.dataMigrationProperties.getVersionTableName()}))) == 0) {
            this.postgreService.getContext().insertInto(DSL.table((Name)DSL.name((String[])new String[]{this.dataMigrationProperties.getVersionTableName()}))).set(DSL.field((String)"id"), (Object)this.dataMigrationProperties.getVersionTableName()).set(DSL.field((String)"value"), (Object)0L).execute();
        }
    }

    public void updateVersion(Long version) {
        this.postgreService.getContext().update(DSL.table((Name)DSL.name((String[])new String[]{this.dataMigrationProperties.getVersionTableName()}))).set(DSL.field((String)"value"), (Object)version).where(new Condition[]{DSL.field((String)"id").eq((Object)this.dataMigrationProperties.getVersionTableName())}).execute();
    }

    public Long currentVersion() {
        return (Long)((Record1)this.postgreService.getContext().select((SelectField)DSL.field((String)"value", (DataType)SQLDataType.BIGINT)).from(this.dataMigrationProperties.getVersionTableName()).where(new Condition[]{DSL.field((String)"id").eq((Object)this.dataMigrationProperties.getVersionTableName())}).fetchOne()).value1();
    }
}

