/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.configuration;

import com.blibli.oss.kafka.aop.KafkaListenerAdvisor;
import com.blibli.oss.kafka.aop.KafkaListenerInterceptor;
import com.blibli.oss.kafka.aop.KafkaListenerPointcut;
import com.blibli.oss.kafka.aspect.KafkaListenerAspect;
import com.blibli.oss.kafka.configuration.KafkaPropertiesAutoConfiguration;
import com.blibli.oss.kafka.producer.PlainKafkaProducer;
import com.blibli.oss.kafka.producer.impl.PlainKafkaProducerImpl;
import com.blibli.oss.kafka.properties.KafkaProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@EnableKafka
@EnableAspectJAutoProxy
@ConditionalOnClass(value={ObjectMapper.class, KafkaTemplate.class})
@AutoConfigureAfter(value={KafkaPropertiesAutoConfiguration.class})
public class KafkaAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"kafka.plugin.aspectj"}, havingValue="true", matchIfMissing=true)
    public KafkaListenerAspect kafkaListenerAspect(@Autowired ObjectMapper objectMapper, @Autowired KafkaProperties kafkaProperties) {
        return new KafkaListenerAspect(objectMapper, kafkaProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"kafka.plugin.aspectj"}, havingValue="false")
    public KafkaListenerPointcut kafkaListenerPointcut() {
        return new KafkaListenerPointcut();
    }

    @Bean
    @ConditionalOnProperty(value={"kafka.plugin.aspectj"}, havingValue="false")
    public KafkaListenerInterceptor kafkaListenerInterceptor(@Autowired ObjectMapper objectMapper, @Autowired KafkaProperties kafkaProperties) {
        return new KafkaListenerInterceptor(objectMapper, kafkaProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"kafka.plugin.aspectj"}, havingValue="false")
    public KafkaListenerAdvisor kafkaListenerAdvisor(KafkaListenerPointcut kafkaListenerPointcut, KafkaListenerInterceptor kafkaListenerInterceptor) {
        return new KafkaListenerAdvisor(kafkaListenerPointcut, kafkaListenerInterceptor);
    }

    @Bean
    public PlainKafkaProducer plainKafkaProducer(@Autowired ObjectMapper objectMapper, @Autowired KafkaTemplate<String, String> kafkaTemplate) {
        return new PlainKafkaProducerImpl(objectMapper, kafkaTemplate);
    }
}

