/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.configuration;

import com.blibli.oss.kafka.configuration.KafkaPropertiesAutoConfiguration;
import com.blibli.oss.kafka.interceptor.IdentityInterceptor;
import com.blibli.oss.kafka.interceptor.LogInterceptor;
import com.blibli.oss.kafka.interceptor.RoutingInterceptor;
import com.blibli.oss.kafka.properties.KafkaProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@ConditionalOnClass(value={KafkaTemplate.class})
@AutoConfigureAfter(value={KafkaPropertiesAutoConfiguration.class})
public class KafkaInterceptorAutoConfiguration {
    @Bean
    public LogInterceptor logInterceptor(@Autowired KafkaProperties kafkaProperties) {
        return new LogInterceptor(kafkaProperties.getLog());
    }

    @Bean
    public IdentityInterceptor identityInterceptor(@Autowired KafkaProperties kafkaProperties) {
        return new IdentityInterceptor(kafkaProperties);
    }

    @Bean
    public RoutingInterceptor routingInterceptor(@Autowired KafkaProperties kafkaProperties) {
        return new RoutingInterceptor(kafkaProperties.getModel());
    }
}

