/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.configuration;

import com.blibli.oss.kafka.configuration.KafkaAutoConfiguration;
import com.blibli.oss.kafka.properties.KafkaProperties;
import com.blibli.oss.kafka.sleuth.SleuthSpanConsumerInterceptor;
import com.blibli.oss.kafka.sleuth.SleuthSpanProducerInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class, KafkaTemplate.class, Tracer.class})
@AutoConfigureAfter(value={KafkaAutoConfiguration.class})
public class KafkaSleuthAutoConfiguration {
    @Bean
    public SleuthSpanProducerInterceptor sleuthSpanProducerInterceptor(@Autowired KafkaProperties kafkaProperties, @Autowired Tracer tracer) {
        return new SleuthSpanProducerInterceptor(kafkaProperties.getModel(), tracer);
    }

    @Bean
    public SleuthSpanConsumerInterceptor sleuthSpanConsumerInterceptor(@Autowired KafkaProperties kafkaProperties, @Autowired ObjectMapper objectMapper, @Autowired Tracer tracer, @Autowired SleuthProperties sleuthProperties) {
        return new SleuthSpanConsumerInterceptor(kafkaProperties.getModel(), objectMapper, tracer, sleuthProperties);
    }
}

