/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.helper;

import com.blibli.oss.kafka.interceptor.events.ConsumerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaHelper {
    private static final Logger log = LoggerFactory.getLogger(KafkaHelper.class);

    public static ConsumerEvent toConsumerEvent(ConsumerRecord<String, String> record, String eventId) {
        return ConsumerEvent.builder().eventId(eventId).key((String)record.key()).partition(record.partition()).timestamp(record.timestamp()).topic(record.topic()).value((String)record.value()).build();
    }

    public static String getEventId(String message, ObjectMapper objectMapper, KafkaProperties kafkaProperties) {
        try {
            return Optional.ofNullable(objectMapper.readTree(message)).map(jsonNode -> jsonNode.get(kafkaProperties.getModel().getIdentity())).map(JsonNode::asText).orElse(null);
        }
        catch (Throwable throwable) {
            if (kafkaProperties.getLog().isWhenFailedGetEventId()) {
                log.warn("Error while get event id", throwable);
            }
            return null;
        }
    }
}

