/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.interceptor;

import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ProducerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class IdentityInterceptor
implements KafkaProducerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IdentityInterceptor.class);
    private KafkaProperties kafkaProperties;

    public IdentityInterceptor(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }

    @Override
    public void beforeSend(ProducerEvent event) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(event.getValue().getClass(), (String)this.kafkaProperties.getModel().getIdentity());
        if (descriptor != null && !this.isIdentityExists(event.getValue(), descriptor)) {
            log.debug("Event id is not exists");
            this.writeIdentityId(event.getValue(), descriptor);
        }
    }

    private void writeIdentityId(Object message, PropertyDescriptor descriptor) {
        block3: {
            Method method = descriptor.getWriteMethod();
            if (method != null) {
                try {
                    String eventId = UUID.randomUUID().toString();
                    method.invoke(message, eventId);
                    log.debug("Inject event id {} to message", (Object)eventId);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (!this.kafkaProperties.getLog().isWhenFailedSetEventId()) break block3;
                    log.warn("Error while write identity id", (Throwable)e);
                }
            }
        }
    }

    private boolean isIdentityExists(Object message, PropertyDescriptor descriptor) {
        block3: {
            Method method = descriptor.getReadMethod();
            if (method != null) {
                try {
                    return method.invoke(message, new Object[0]) != null;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (!this.kafkaProperties.getLog().isWhenFailedSetEventId()) break block3;
                    log.warn("Error while read identity id", (Throwable)e);
                }
            }
        }
        return false;
    }
}

