/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.interceptor;

import com.blibli.oss.kafka.interceptor.KafkaConsumerInterceptor;
import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ConsumerEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;

public class InterceptorUtil {
    private static final Logger log = LoggerFactory.getLogger(InterceptorUtil.class);

    public static boolean fireBeforeConsume(Object bean, Method method, List<KafkaConsumerInterceptor> kafkaConsumerInterceptors, ConsumerEvent event) {
        for (KafkaConsumerInterceptor interceptor : kafkaConsumerInterceptors) {
            try {
                if (!interceptor.isSupport(bean, method) || !interceptor.beforeConsume(event)) continue;
                return true;
            }
            catch (Throwable throwable) {
                log.error("Error while invoke interceptor", throwable);
            }
        }
        return false;
    }

    public static void fireAfterSuccessConsume(Object bean, Method method, List<KafkaConsumerInterceptor> kafkaConsumerInterceptors, ConsumerEvent event) {
        for (KafkaConsumerInterceptor interceptor : kafkaConsumerInterceptors) {
            try {
                if (!interceptor.isSupport(bean, method)) continue;
                interceptor.afterSuccessConsume(event);
            }
            catch (Throwable throwable) {
                log.error("Error while invoke interceptor", throwable);
            }
        }
    }

    public static void fireAfterErrorConsume(Object bean, Method method, List<KafkaConsumerInterceptor> kafkaConsumerInterceptors, ConsumerEvent event, Throwable throwable) {
        for (KafkaConsumerInterceptor interceptor : kafkaConsumerInterceptors) {
            try {
                if (!interceptor.isSupport(bean, method)) continue;
                interceptor.afterFailedConsume(event, throwable);
            }
            catch (Throwable e) {
                log.error("Error while invoke interceptor", e);
            }
        }
    }

    public static List<KafkaProducerInterceptor> getKafkaProducerInterceptors(ApplicationContext applicationContext) {
        List<KafkaProducerInterceptor> interceptors = Collections.emptyList();
        Map beans = applicationContext.getBeansOfType(KafkaProducerInterceptor.class);
        if (beans != null && !beans.isEmpty()) {
            interceptors = new ArrayList(beans.values());
        }
        OrderComparator.sort(interceptors);
        return interceptors;
    }

    public static List<KafkaConsumerInterceptor> getKafkaConsumerInterceptors(ApplicationContext applicationContext) {
        List<KafkaConsumerInterceptor> interceptors = Collections.emptyList();
        Map beans = applicationContext.getBeansOfType(KafkaConsumerInterceptor.class);
        if (beans != null && !beans.isEmpty()) {
            interceptors = new ArrayList(beans.values());
        }
        OrderComparator.sort(interceptors);
        return interceptors;
    }
}

