/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.interceptor;

import com.blibli.oss.kafka.interceptor.KafkaConsumerInterceptor;
import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ConsumerEvent;
import com.blibli.oss.kafka.interceptor.events.ProducerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptor
implements KafkaConsumerInterceptor,
KafkaProducerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private KafkaProperties.LogProperties logProperties;

    public LogInterceptor(KafkaProperties.LogProperties logProperties) {
        this.logProperties = logProperties;
    }

    @Override
    public void beforeSend(ProducerEvent event) {
        if (this.logProperties.isBeforeSend()) {
            log.info("Send to topic {} with message {}", (Object)event.getTopic(), event.getValue());
        }
    }

    @Override
    public boolean beforeConsume(ConsumerEvent event) {
        if (this.logProperties.isBeforeConsume()) {
            log.info("Receive from topic {} with message {}", (Object)event.getTopic(), (Object)event.getValue());
        }
        return false;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

