/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.interceptor;

import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ProducerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class RoutingInterceptor
implements KafkaProducerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RoutingInterceptor.class);
    private KafkaProperties.ModelProperties modelProperties;

    public RoutingInterceptor(KafkaProperties.ModelProperties modelProperties) {
        this.modelProperties = modelProperties;
    }

    @Override
    public void beforeSend(ProducerEvent event) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(event.getValue().getClass(), (String)this.modelProperties.getRouting());
        if (descriptor != null) {
            this.setKeyFromRoutingProperty(event, descriptor);
        }
    }

    private void setKeyFromRoutingProperty(ProducerEvent event, PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            try {
                String routingId = (String)method.invoke(event.getValue(), new Object[0]);
                if (routingId == null) {
                    routingId = UUID.randomUUID().toString();
                }
                event.setKey(routingId);
                log.debug("Inject routing id {} to message", (Object)routingId);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Error while get routing id", (Throwable)e);
            }
        }
    }
}

