/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.producer.impl;

import com.blibli.oss.kafka.interceptor.InterceptorUtil;
import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ProducerEvent;
import com.blibli.oss.kafka.producer.PlainKafkaProducer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class PlainKafkaProducerImpl
implements PlainKafkaProducer,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PlainKafkaProducerImpl.class);
    private ObjectMapper objectMapper;
    private KafkaTemplate<String, String> kafkaTemplate;
    private ApplicationContext applicationContext;
    private List<KafkaProducerInterceptor> kafkaProducerInterceptors;

    public PlainKafkaProducerImpl(ObjectMapper objectMapper, KafkaTemplate<String, String> kafkaTemplate) {
        this.objectMapper = objectMapper;
        this.kafkaTemplate = kafkaTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        this.kafkaProducerInterceptors = InterceptorUtil.getKafkaProducerInterceptors(this.applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ListenableFuture<SendResult<String, String>> send(String topic, String key, Object message, Integer partition, Long timestamp) {
        try {
            ProducerEvent event = ProducerEvent.builder().key(key).topic(topic).value(message).partition(partition).timestamp(timestamp).build();
            this.fireBeforeSend(event);
            String json = this.objectMapper.writeValueAsString(event.getValue());
            return this.kafkaTemplate.send(new ProducerRecord(event.getTopic(), event.getPartition(), event.getTimestamp(), (Object)event.getKey(), (Object)json));
        }
        catch (JsonProcessingException e) {
            SettableListenableFuture future = new SettableListenableFuture();
            future.setException((Throwable)e);
            return future;
        }
    }

    private void fireBeforeSend(ProducerEvent event) {
        for (KafkaProducerInterceptor interceptor : this.kafkaProducerInterceptors) {
            try {
                interceptor.beforeSend(event);
            }
            catch (Throwable throwable) {
                log.error("Error while invoking interceptor", throwable);
            }
        }
    }
}

