/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.sleuth;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

public class SleuthHelper {
    public static void continueSpan(Tracer tracer, Map<String, String> map) {
        if (tracer != null && map != null && !map.isEmpty()) {
            tracer.continueSpan(SleuthHelper.fromMap(map));
        }
    }

    public static void joinSpan(Tracer tracer, Map<String, String> map) {
        Span parent;
        if (tracer != null && map != null && !map.isEmpty() && (parent = SleuthHelper.fromMap(map)) != null) {
            tracer.createSpan(parent.getName(), parent);
        }
    }

    public static Map<String, String> toMap(Span span) {
        if (span == null) {
            return Collections.emptyMap();
        }
        return SleuthHelper.convertSpanToMap(span);
    }

    private static Map<String, String> convertSpanToMap(Span span) {
        HashMap<String, String> map = new HashMap<String, String>();
        List parents = span.getParents().stream().map(String::valueOf).collect(Collectors.toList());
        map.put("X-Span-Name", span.getName());
        map.put("X-B3-ParentSpanId", String.join((CharSequence)",", parents));
        map.put("X-B3-TraceId", String.valueOf(span.getTraceId()));
        map.put("X-Process-Id", span.getProcessId());
        map.put("X-B3-SpanId", String.valueOf(span.getSpanId()));
        map.put("X-Span-Export", String.valueOf(span.isExportable()));
        span.getBaggage().forEach((key, value) -> map.put("baggage" + key, (String)value));
        return map;
    }

    public static Span fromMap(Map<String, String> map) {
        return Span.builder().name(map.get("X-Span-Name")).parents(SleuthHelper.getParents(map.get("X-B3-ParentSpanId"))).traceId(Long.valueOf(map.get("X-B3-TraceId")).longValue()).processId(map.get("X-Process-Id")).spanId(Long.valueOf(map.get("X-B3-SpanId")).longValue()).exportable(Boolean.valueOf(map.get("X-Span-Export")).booleanValue()).baggage(SleuthHelper.getBaggage(map)).build();
    }

    private static Map<String, String> getBaggage(Map<String, String> map) {
        List<Map.Entry> collect = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("baggage")).collect(Collectors.toList());
        HashMap<String, String> baggage = new HashMap<String, String>(collect.size());
        collect.forEach(entry -> {
            String key = ((String)entry.getKey()).replaceFirst("baggage", "");
            baggage.put(key, (String)entry.getValue());
        });
        return baggage;
    }

    private static List<Long> getParents(String parents) {
        if (parents == null || parents.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(parents.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }
}

