/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.sleuth;

import com.blibli.oss.kafka.interceptor.KafkaConsumerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ConsumerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import com.blibli.oss.kafka.sleuth.SleuthHelper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;

public class SleuthSpanConsumerInterceptor
implements KafkaConsumerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SleuthSpanConsumerInterceptor.class);
    private static final String KAFKA_COMPONENT = "kafka:consumer";
    private KafkaProperties.ModelProperties modelProperties;
    private ObjectMapper objectMapper;
    private Tracer tracer;
    private SleuthProperties sleuthProperties;

    public SleuthSpanConsumerInterceptor(KafkaProperties.ModelProperties modelProperties, ObjectMapper objectMapper, Tracer tracer, SleuthProperties sleuthProperties) {
        this.modelProperties = modelProperties;
        this.objectMapper = objectMapper;
        this.tracer = tracer;
        this.sleuthProperties = sleuthProperties;
    }

    @Override
    public boolean beforeConsume(ConsumerEvent event) {
        try {
            Map<String, String> span = this.getSpan(event.getValue());
            if (span != null && !span.isEmpty()) {
                if (this.sleuthProperties.isSupportsJoin()) {
                    SleuthHelper.joinSpan(this.tracer, span);
                    log.debug("Join trace span {}", span);
                } else {
                    SleuthHelper.continueSpan(this.tracer, span);
                    log.debug("Continue trace span {}", span);
                }
            } else {
                String name = "kafka:consumer:" + event.getTopic();
                this.tracer.close(this.tracer.getCurrentSpan());
                this.tracer.createSpan(name);
                log.debug("Sleuth span is not available, create new one");
            }
        }
        catch (Throwable throwable) {
            log.error("Failed continue span", throwable);
        }
        return false;
    }

    private Map<String, String> getSpan(String json) throws IOException {
        return Optional.ofNullable(this.objectMapper.readTree(json)).map(value -> value.get(this.modelProperties.getTrace())).map(value -> this.objectMapper.treeAsTokens((TreeNode)value)).map(this::getMap).orElse(Collections.emptyMap());
    }

    private Map<String, String> getMap(JsonParser value) {
        try {
            return (Map)this.objectMapper.readValue(value, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            log.error("Failed get map from span attribute", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

