/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.kafka.sleuth;

import com.blibli.oss.kafka.interceptor.KafkaProducerInterceptor;
import com.blibli.oss.kafka.interceptor.events.ProducerEvent;
import com.blibli.oss.kafka.properties.KafkaProperties;
import com.blibli.oss.kafka.sleuth.SleuthHelper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.sleuth.Tracer;

public class SleuthSpanProducerInterceptor
implements KafkaProducerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SleuthSpanProducerInterceptor.class);
    private static final String KAFKA_COMPONENT = "kafka:producer";
    private KafkaProperties.ModelProperties modelProperties;
    private Tracer tracer;

    public SleuthSpanProducerInterceptor(KafkaProperties.ModelProperties modelProperties, Tracer tracer) {
        this.modelProperties = modelProperties;
        this.tracer = tracer;
    }

    @Override
    public void beforeSend(ProducerEvent event) {
        Method method;
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(event.getValue().getClass(), (String)this.modelProperties.getTrace());
        if (descriptor != null && (method = descriptor.getWriteMethod()) != null) {
            try {
                if (this.tracer.getCurrentSpan() == null) {
                    String name = "kafka:producer:" + event.getTopic();
                    this.tracer.createSpan(name);
                    log.debug("Sleuth span is not available, create new one");
                }
                Map<String, String> span = SleuthHelper.toMap(this.tracer.getCurrentSpan());
                method.invoke(event.getValue(), span);
                log.debug("Inject trace span {} to message", span);
            }
            catch (Throwable e) {
                log.error("Error while write span information", e);
            }
        }
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

