/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.config;

import com.blinkfox.zealot.config.entity.NormalConfig;
import com.blinkfox.zealot.config.entity.TagHandler;
import com.blinkfox.zealot.config.entity.XmlContext;
import com.blinkfox.zealot.core.IConditHandler;
import com.blinkfox.zealot.core.concrete.BetweenHandler;
import com.blinkfox.zealot.core.concrete.ChooseHandler;
import com.blinkfox.zealot.core.concrete.ImportHandler;
import com.blinkfox.zealot.core.concrete.InHandler;
import com.blinkfox.zealot.core.concrete.IsNullHandler;
import com.blinkfox.zealot.core.concrete.LikeHandler;
import com.blinkfox.zealot.core.concrete.NormalHandler;
import com.blinkfox.zealot.core.concrete.TextHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Node;

public class AbstractZealotConfig {
    private static final Map<String, Node> zealots = new ConcurrentHashMap<String, Node>();
    private static final Map<String, TagHandler> tagHandlerMap = new HashMap<String, TagHandler>();

    public static Map<String, Node> getZealots() {
        return zealots;
    }

    public static Map<String, TagHandler> getTagHandlerMap() {
        return tagHandlerMap;
    }

    protected static void add(String tagName, Class<? extends IConditHandler> handlerCls) {
        tagHandlerMap.put(tagName, new TagHandler(handlerCls));
    }

    protected static void add(String tagName, String prefix, Class<? extends IConditHandler> handlerCls) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerCls));
    }

    protected static void add(String tagName, Class<? extends IConditHandler> handlerCls, String suffix) {
        tagHandlerMap.put(tagName, new TagHandler(handlerCls, suffix));
    }

    protected static void add(String tagName, String prefix, Class<? extends IConditHandler> handlerCls, String suffix) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerCls, suffix));
    }

    public void configNormal(NormalConfig normalConfig) {
        normalConfig.setDebug(false).setPrintBanner(true).setPrintSqlInfo(true);
    }

    public void configXml(XmlContext ctx) {
    }

    public void configTagHandler() {
    }

    static {
        AbstractZealotConfig.add("equal", NormalHandler.class, " = ? ");
        AbstractZealotConfig.add("andEqual", " AND ", NormalHandler.class, " = ? ");
        AbstractZealotConfig.add("orEqual", " OR ", NormalHandler.class, " = ? ");
        AbstractZealotConfig.add("notEqual", NormalHandler.class, " <> ? ");
        AbstractZealotConfig.add("andNotEqual", " AND ", NormalHandler.class, " <> ? ");
        AbstractZealotConfig.add("orNotEqual", " OR ", NormalHandler.class, " <> ? ");
        AbstractZealotConfig.add("moreThan", NormalHandler.class, " > ? ");
        AbstractZealotConfig.add("andMoreThan", " AND ", NormalHandler.class, " > ? ");
        AbstractZealotConfig.add("orMoreThan", " OR ", NormalHandler.class, " > ? ");
        AbstractZealotConfig.add("lessThan", NormalHandler.class, " < ? ");
        AbstractZealotConfig.add("andLessThan", " AND ", NormalHandler.class, " < ? ");
        AbstractZealotConfig.add("orLessThan", " OR ", NormalHandler.class, " < ? ");
        AbstractZealotConfig.add("moreEqual", NormalHandler.class, " >= ? ");
        AbstractZealotConfig.add("andMoreEqual", " AND ", NormalHandler.class, " >= ? ");
        AbstractZealotConfig.add("orMoreEqual", " OR ", NormalHandler.class, " >= ? ");
        AbstractZealotConfig.add("lessEqual", NormalHandler.class, " <= ? ");
        AbstractZealotConfig.add("andLessEqual", " AND ", NormalHandler.class, " <= ? ");
        AbstractZealotConfig.add("orLessEqual", " OR ", NormalHandler.class, " <= ? ");
        AbstractZealotConfig.add("like", LikeHandler.class, " LIKE ");
        AbstractZealotConfig.add("andLike", " AND ", LikeHandler.class, " LIKE ");
        AbstractZealotConfig.add("orLike", " OR ", LikeHandler.class, " LIKE ");
        AbstractZealotConfig.add("notLike", LikeHandler.class, " NOT LIKE ");
        AbstractZealotConfig.add("andNotLike", " AND ", LikeHandler.class, " NOT LIKE ");
        AbstractZealotConfig.add("orNotLike", " OR ", LikeHandler.class, " NOT LIKE ");
        AbstractZealotConfig.add("between", BetweenHandler.class);
        AbstractZealotConfig.add("andBetween", " AND ", BetweenHandler.class);
        AbstractZealotConfig.add("orBetween", " OR ", BetweenHandler.class);
        AbstractZealotConfig.add("in", InHandler.class, " IN ");
        AbstractZealotConfig.add("andIn", " AND ", InHandler.class, " IN ");
        AbstractZealotConfig.add("orIn", " OR ", InHandler.class, " IN ");
        AbstractZealotConfig.add("notIn", InHandler.class, " NOT IN ");
        AbstractZealotConfig.add("andNotIn", " AND ", InHandler.class, " NOT IN ");
        AbstractZealotConfig.add("orNotIn", " OR ", InHandler.class, " NOT IN ");
        AbstractZealotConfig.add("isNull", IsNullHandler.class, " IS NULL ");
        AbstractZealotConfig.add("andIsNull", " AND ", IsNullHandler.class, " IS NULL ");
        AbstractZealotConfig.add("orIsNull", " OR ", IsNullHandler.class, " IS NULL ");
        AbstractZealotConfig.add("isNotNull", IsNullHandler.class, " IS NOT NULL ");
        AbstractZealotConfig.add("andIsNotNull", " AND ", IsNullHandler.class, " IS NOT NULL ");
        AbstractZealotConfig.add("orIsNotNull", " OR ", IsNullHandler.class, " IS NOT NULL ");
        AbstractZealotConfig.add("text", TextHandler.class);
        AbstractZealotConfig.add("import", ImportHandler.class);
        AbstractZealotConfig.add("choose", ChooseHandler.class);
    }
}

