/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.config;

import com.blinkfox.zealot.config.AbstractZealotConfig;
import com.blinkfox.zealot.config.entity.NormalConfig;
import com.blinkfox.zealot.config.entity.XmlContext;
import com.blinkfox.zealot.config.scanner.TaggerScanner;
import com.blinkfox.zealot.config.scanner.XmlScanner;
import com.blinkfox.zealot.exception.ConfigNotFoundException;
import com.blinkfox.zealot.exception.NodeNotFoundException;
import com.blinkfox.zealot.helpers.ParseHelper;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.helpers.XmlNodeHelper;
import com.blinkfox.zealot.loader.BannerLoader;
import com.blinkfox.zealot.log.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Node;

public class ZealotConfigManager {
    private static final Log log = Log.get(ZealotConfigManager.class);
    private static final ZealotConfigManager confManager = new ZealotConfigManager();
    private String xmlLocations;
    private String handlerLocations;

    private ZealotConfigManager() {
    }

    public static ZealotConfigManager getInstance() {
        return confManager;
    }

    public String getXmlLocations() {
        return this.xmlLocations;
    }

    public String getHandlerLocations() {
        return this.handlerLocations;
    }

    public void initLoad(String configClass, String xmlLocations, String handlerLocations) {
        this.xmlLocations = xmlLocations;
        this.handlerLocations = handlerLocations;
        this.initLoad(configClass);
    }

    public void initLoad(Class<? extends AbstractZealotConfig> clazz, String xmlLocations, String handlerLocations) {
        this.initLoad(clazz.getName(), xmlLocations, handlerLocations);
    }

    public void initLoad(AbstractZealotConfig zealotConfig, String xmlLocations, String handlerLocations) {
        this.xmlLocations = xmlLocations;
        this.handlerLocations = handlerLocations;
        this.initLoad(zealotConfig);
    }

    public void initLoad(Class<? extends AbstractZealotConfig> clazz) {
        this.initLoad(clazz.getName());
    }

    public void initLoad(String configClass) {
        this.scanLocations(this.xmlLocations, this.handlerLocations);
        this.loadZealotConfig(configClass);
        this.cachingXmlAndEval();
    }

    public void initLoad(AbstractZealotConfig zealotConfig) {
        this.scanLocations(this.xmlLocations, this.handlerLocations);
        this.loadZealotConfig(zealotConfig);
        this.cachingXmlAndEval();
    }

    private void scanLocations(String xmlLocations, String handlerLocations) {
        this.xmlLocations = StringHelper.isBlank(this.xmlLocations) ? "zealot" : this.xmlLocations;
        XmlScanner.newInstance().scan(xmlLocations);
        TaggerScanner.newInstance().scan(handlerLocations);
    }

    public ZealotConfigManager initLoadXmlLocations(String xmlLocations) {
        this.xmlLocations = StringHelper.isBlank(xmlLocations) ? "zealot" : xmlLocations;
        XmlScanner.newInstance().scan(this.xmlLocations);
        this.cachingXmlAndEval();
        return this;
    }

    public ZealotConfigManager initLoadHandlerLocations(String handlerLocations) {
        this.handlerLocations = handlerLocations;
        TaggerScanner.newInstance().scan(handlerLocations);
        return this;
    }

    public void clear() {
        XmlContext.INSTANCE.getXmlPathMap().clear();
        AbstractZealotConfig.getZealots().clear();
    }

    private void loadZealotConfig(String configClass) {
        Object temp;
        if (configClass == null) {
            throw new ConfigNotFoundException("\u672a\u83b7\u53d6\u5230ZealotConfig\u914d\u7f6e\u4fe1\u606f");
        }
        log.info("Zealot\u52a0\u8f7d\u5668\u5f00\u59cb\u52a0\u8f7d\uff0cZealot\u914d\u7f6e\u7c7b\u4e3a:" + configClass);
        try {
            temp = Class.forName(configClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigNotFoundException("\u521d\u59cb\u5316zealotConfig\u5b9e\u4f8b\u5931\u8d25,\u914d\u7f6e\u540d\u79f0\u4e3a:" + configClass, e);
        }
        if (temp instanceof AbstractZealotConfig) {
            this.loadZealotConfig((AbstractZealotConfig)temp);
        }
    }

    private void loadZealotConfig(AbstractZealotConfig zealotConfig) {
        zealotConfig.configNormal(NormalConfig.getInstance());
        zealotConfig.configXml(XmlContext.INSTANCE);
        zealotConfig.configTagHandler();
        log.warn("Zealot\u7684\u914d\u7f6e\u4fe1\u606f\u52a0\u8f7d\u5b8c\u6210!");
    }

    private void cachingXmlAndEval() {
        this.cachingXmlZealots();
        BannerLoader.newInstance().print(NormalConfig.getInstance().isPrintBanner());
        this.testFirstEvaluate();
    }

    private void cachingXmlZealots() {
        Map<String, String> xmlMaps = XmlContext.INSTANCE.getXmlPathMap();
        for (Map.Entry<String, String> entry : xmlMaps.entrySet()) {
            String nameSpace = entry.getKey();
            String filePath = entry.getValue();
            Document doc = XmlNodeHelper.getDocument(filePath);
            if (doc == null) {
                throw new ConfigNotFoundException("\u6ce8\u610f\uff1a\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6\u4e2dxml\u5bf9\u5e94\u7684dom4j Document\u6587\u6863,nameSpace\u4e3a:" + nameSpace);
            }
            List zealotNodes = doc.selectNodes("zealots/zealot");
            for (Node zealotNode : zealotNodes) {
                String zealotId = XmlNodeHelper.getNodeText(zealotNode.selectSingleNode("attribute::id"));
                if (StringHelper.isBlank(zealotId)) {
                    throw new NodeNotFoundException("\u8be5xml\u6587\u4ef6\u4e2d\u6709zealot\u8282\u70b9\u7684zealotId\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01\u6587\u4ef6\u4e3a:" + filePath);
                }
                String zealotKey = StringHelper.concat(nameSpace, "@@", zealotId);
                AbstractZealotConfig.getZealots().put(zealotKey, zealotNode);
            }
        }
    }

    private void testFirstEvaluate() {
        HashMap<String, String> context = new HashMap<String, String>(4);
        context.put("foo", "hello");
        ParseHelper.parseTemplate("@if{?foo != empty}Hello World!@end{}", context);
        ParseHelper.parseExpressWithException("foo != empty", context);
    }
}

