/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.config.scanner;

import com.blinkfox.zealot.config.scanner.XmlScanner;
import com.blinkfox.zealot.exception.ZealotException;
import com.blinkfox.zealot.helpers.IoHelper;
import com.blinkfox.zealot.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class DefaultVfs {
    private static final Log log = Log.get(XmlScanner.class);
    private static final String PATH_SP = "/";
    private static final long MAX_LIMIT = 3000L;
    private static final String FILE_PROTOCOL = "file";
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    public static DefaultVfs newInstance() {
        return new DefaultVfs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list(URL url, String path) throws IOException {
        ArrayList<String> arrayList;
        ArrayList<String> resources;
        InputStream is;
        block5: {
            is = null;
            resources = new ArrayList<String>();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl == null) break block5;
            is = jarUrl.openStream();
            List<String> list = this.listResources(new JarInputStream(is), path);
            IoHelper.closeQuietly(is);
            return list;
        }
        try {
            List<String> children = new ArrayList<String>();
            children = this.getResourceUrls(url, path, is, children);
            String prefix = url.toExternalForm();
            if (!prefix.endsWith(PATH_SP)) {
                prefix = prefix + PATH_SP;
            }
            for (String child : children) {
                String resourcePath = path + PATH_SP + child;
                resources.add(resourcePath);
                URL childUrl = new URL(prefix + child);
                resources.addAll(this.list(childUrl, resourcePath));
            }
            arrayList = resources;
        }
        catch (Throwable throwable) {
            IoHelper.closeQuietly(is);
            throw throwable;
        }
        IoHelper.closeQuietly(is);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getResourceUrls(URL url, String path, InputStream is, List<String> children) throws IOException {
        block10: {
            JarInputStream jarInput = null;
            BufferedReader reader = null;
            try {
                if (this.isJar(url)) {
                    JarEntry entry;
                    is = url.openStream();
                    jarInput = new JarInputStream(is);
                    while ((entry = jarInput.getNextJarEntry()) != null) {
                        children.add(entry.getName());
                    }
                    jarInput.close();
                } else {
                    String line;
                    is = url.openStream();
                    reader = new BufferedReader(new InputStreamReader(is));
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                        if (!this.getResources(path + PATH_SP + line).isEmpty()) continue;
                        lines.clear();
                        break;
                    }
                    if (!lines.isEmpty()) {
                        children.addAll(lines);
                    }
                }
                IoHelper.closeQuietly(jarInput);
            }
            catch (FileNotFoundException e) {
                children = this.getUrls(url, children, e);
                break block10;
            }
            finally {
                IoHelper.closeQuietly(jarInput);
                IoHelper.closeQuietly(reader);
                IoHelper.closeQuietly(is);
            }
            IoHelper.closeQuietly(reader);
            IoHelper.closeQuietly(is);
        }
        return children;
    }

    private List<String> getUrls(URL url, List<String> children, FileNotFoundException e) throws IOException {
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            File file = new File(url.getFile());
            if (file.isDirectory()) {
                children = Arrays.asList(file.list());
            }
        } else {
            throw e;
        }
        return children;
    }

    private List<URL> getResources(String path) throws IOException {
        return Collections.list(Thread.currentThread().getContextClassLoader().getResources(path));
    }

    private List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith(PATH_SP)) {
            path = PATH_SP + path;
        }
        if (!path.endsWith(PATH_SP)) {
            path = path + PATH_SP;
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            StringBuilder sb = new StringBuilder("");
            if (!name.startsWith(PATH_SP)) {
                name = sb.append(PATH_SP).append(name).toString();
            }
            if (!name.startsWith(path)) continue;
            resources.add(name.substring(1));
        }
        return resources;
    }

    private URL findJarForResource(URL url) {
        try {
            long startTime = System.currentTimeMillis();
            do {
                url = new URL(url.getFile());
            } while (System.currentTimeMillis() - startTime <= 3000L);
        }
        catch (MalformedURLException startTime) {
            // empty catch block
        }
        StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
        int index = jarUrl.lastIndexOf(".jar");
        if (index < 0) {
            return null;
        }
        jarUrl.setLength(index + 4);
        try {
            URL testUrl = new URL(jarUrl.toString());
            if (this.isJar(testUrl)) {
                return testUrl;
            }
            jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
            File file = new File(jarUrl.toString());
            if (!file.exists()) {
                file = new File(URLEncoder.encode(jarUrl.toString(), "UTF-8"));
            }
            if (file.exists() && this.isJar(testUrl = file.toURI().toURL())) {
                return testUrl;
            }
        }
        catch (MalformedURLException e) {
            log.warn("Invalid JAR URL: " + jarUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZealotException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
        return null;
    }

    private boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            IoHelper.closeQuietly(is);
        }
        return false;
    }
}

