/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.config.scanner;

import com.blinkfox.zealot.config.AbstractZealotConfig;
import com.blinkfox.zealot.config.annotation.Tagger;
import com.blinkfox.zealot.config.annotation.Taggers;
import com.blinkfox.zealot.config.entity.TagHandler;
import com.blinkfox.zealot.config.scanner.Scanner;
import com.blinkfox.zealot.core.IConditHandler;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.log.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class TaggerScanner
implements Scanner {
    private static Log log = Log.get(TaggerScanner.class);
    private Set<Class<?>> classSet = new HashSet();

    private TaggerScanner() {
    }

    public static TaggerScanner newInstance() {
        return new TaggerScanner();
    }

    @Override
    public void scan(String handlerLocations) {
        String[] locationArr;
        if (StringHelper.isBlank(handlerLocations)) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String location : locationArr = handlerLocations.split(",")) {
            if (StringHelper.isBlank(location)) continue;
            String cleanLocation = location.trim();
            if (StringHelper.isJavaFile(cleanLocation) || StringHelper.isClassFile(cleanLocation)) {
                this.addClassByName(classLoader, cleanLocation.substring(0, cleanLocation.lastIndexOf(46)));
                continue;
            }
            this.addClassByPackage(classLoader, cleanLocation);
        }
        this.addTagHanderInMap();
    }

    private void addClassByName(ClassLoader classLoader, String className) {
        try {
            this.classSet.add(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException expected) {
            log.warn("\u3010\u8b66\u544a\u3011\u672a\u627e\u5230class\u7c7b:'" + className + "'\uff0c\u5c06\u5ffd\u7565\u4e0d\u89e3\u6790\u6b64\u7c7b.");
        }
    }

    private void addClassByPackage(ClassLoader classLoader, String packageName) {
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> urlEnum = this.getUrlsByPackge(classLoader, packageDirName);
        if (urlEnum == null) {
            return;
        }
        while (urlEnum.hasMoreElements()) {
            URL url = urlEnum.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                try {
                    this.addClassesByFile(classLoader, packageName, URLDecoder.decode(url.getFile(), "UTF-8"));
                }
                catch (UnsupportedEncodingException expected) {
                    log.warn("\u8be5\u5305\u7ed3\u6784\u65e0\u6cd5\u8f6c\u6362\u6210UTF-8\u7684\u7f16\u7801\u683c\u5f0f.");
                }
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            this.addClassByJar(classLoader, url, packageName, packageDirName);
        }
    }

    private Enumeration<URL> getUrlsByPackge(ClassLoader classLoader, String packageName) {
        try {
            return classLoader.getResources(packageName);
        }
        catch (IOException e) {
            log.warn("\u3010\u8b66\u544a\u3011\u672a\u627e\u5230\u5305:'" + packageName + "'\u4e0b\u7684URL\uff0c\u5c06\u5ffd\u7565\u6b64\u79cd\u9519\u8bef\u60c5\u51b5.");
            return null;
        }
    }

    private void addClassesByFile(ClassLoader classLoader, String packageName, String packagePath) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || StringHelper.isClassFile(file.getName());
            }
        });
        if (dirfiles == null) {
            return;
        }
        for (File file : dirfiles) {
            if (file.isDirectory()) {
                this.addClassesByFile(classLoader, packageName + "." + file.getName(), file.getAbsolutePath());
                continue;
            }
            String className = file.getName().substring(0, file.getName().lastIndexOf(46));
            this.addClassByName(classLoader, packageName + '.' + className);
        }
    }

    private void addClassByJar(ClassLoader classLoader, URL url, String packageName, String packageDirName) {
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int index = name.lastIndexOf(47);
                if (index != -1) {
                    packageName = name.substring(0, index).replace('/', '.');
                }
                if (index == -1 || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                this.addClassByName(classLoader, packageName + '.' + className);
            }
        }
        catch (IOException expected) {
            log.warn("\u4ecejar\u6587\u4ef6\u4e2d\u8bfb\u53d6class\u51fa\u9519.");
        }
    }

    private void addTagHanderInMap() {
        for (Class<?> cls : this.classSet) {
            Tagger[] taggerArr;
            if (cls.isAnnotationPresent(Tagger.class) && this.isImplConditHandlerClass(cls)) {
                Class<?> conditCls = cls;
                Tagger tagger = conditCls.getAnnotation(Tagger.class);
                this.addTagHandlerInMapByTagger(conditCls, tagger);
            }
            if (!cls.isAnnotationPresent(Taggers.class) || !this.isImplConditHandlerClass(cls)) continue;
            Taggers taggers = cls.getAnnotation(Taggers.class);
            for (Tagger tagger : taggerArr = taggers.value()) {
                this.addTagHandlerInMapByTagger(cls, tagger);
            }
        }
    }

    private boolean isImplConditHandlerClass(Class<?> implCls) {
        Class<?>[] classes = implCls.getInterfaces();
        if (classes == null) {
            return false;
        }
        for (Class<?> cls : classes) {
            if (!IConditHandler.class.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private void addTagHandlerInMapByTagger(Class<? extends IConditHandler> cls, Tagger tagger) {
        AbstractZealotConfig.getTagHandlerMap().put(tagger.value(), new TagHandler(tagger.prefix(), cls, tagger.symbol()));
    }
}

