/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.config.scanner;

import com.blinkfox.zealot.config.entity.XmlContext;
import com.blinkfox.zealot.config.scanner.DefaultVfs;
import com.blinkfox.zealot.config.scanner.Scanner;
import com.blinkfox.zealot.helpers.CollectionHelper;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.helpers.XmlNodeHelper;
import com.blinkfox.zealot.log.Log;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class XmlScanner
implements Scanner {
    private static final Log log = Log.get(XmlScanner.class);
    private Set<String> xmlPaths = new HashSet<String>();

    private XmlScanner() {
    }

    public static XmlScanner newInstance() {
        return new XmlScanner();
    }

    @Override
    public void scan(String xmlLocations) {
        String[] xmlLocationArr;
        if (StringHelper.isBlank(xmlLocations)) {
            return;
        }
        for (String xmlLocation : xmlLocationArr = xmlLocations.split(",")) {
            if (StringHelper.isBlank(xmlLocation)) continue;
            String cleanXmlLocation = xmlLocation.trim();
            if (StringHelper.isXmlFile(cleanXmlLocation)) {
                this.xmlPaths.add(cleanXmlLocation);
                continue;
            }
            this.scanXmlsByPackage(cleanXmlLocation.replace('.', '/'));
        }
        this.addZealotXmlInContext();
    }

    private void scanXmlsByPackage(String xmlPackage) {
        List<URL> urls = this.getDirUrls(xmlPackage);
        if (CollectionHelper.isEmpty(urls)) {
            return;
        }
        for (URL url : urls) {
            List<String> filePaths = this.getDirFilePaths(xmlPackage, url);
            if (CollectionHelper.isEmpty(filePaths)) continue;
            for (String filePath : filePaths) {
                if (!StringHelper.isXmlFile(filePath)) continue;
                this.xmlPaths.add(filePath);
            }
        }
    }

    private List<URL> getDirUrls(String xmlPackage) {
        try {
            return Collections.list(Thread.currentThread().getContextClassLoader().getResources(xmlPackage));
        }
        catch (IOException e) {
            log.error("\u65e0\u6cd5\u89e3\u6790\u914d\u7f6e\u7684zealot xml\u8def\u5f84\u4e0b\u6587\u4ef6\u7684URL\uff0c\u5c06\u88ab\u5ffd\u7565.\u8be5\u8def\u5f84\u4e3a:" + xmlPackage + "\uff0c\u8bf7\u68c0\u67e5!", e);
            return Collections.emptyList();
        }
    }

    private List<String> getDirFilePaths(String xmlPackage, URL url) {
        try {
            return DefaultVfs.newInstance().list(url, xmlPackage);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790zealot xml\u5305\u5b58\u5728\u4e9b\u95ee\u9898,\u5c06\u88ab\u5ffd\u7565\uff01xml\u5305\u4e3a:" + xmlPackage + ",url:" + url);
            return Collections.emptyList();
        }
    }

    private void addZealotXmlInContext() {
        for (String xmlPath : this.xmlPaths) {
            String nameSpace = XmlNodeHelper.getZealotXmlNameSpace(xmlPath);
            if (!StringHelper.isNotBlank(nameSpace)) continue;
            XmlContext.INSTANCE.add(nameSpace, xmlPath);
        }
    }
}

