/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.config.AbstractZealotConfig;
import com.blinkfox.zealot.config.entity.TagHandler;
import com.blinkfox.zealot.core.IConditHandler;
import com.blinkfox.zealot.exception.NodeNotFoundException;
import com.blinkfox.zealot.log.Log;
import java.util.Map;

public final class ConditContext {
    private static final Log log = Log.get(ConditContext.class);

    private ConditContext() {
    }

    public static SqlInfo buildSqlInfo(BuildSource source, String tag) {
        Map<String, TagHandler> tagHandlerMap = AbstractZealotConfig.getTagHandlerMap();
        if (tagHandlerMap.containsKey(tag)) {
            TagHandler th = tagHandlerMap.get(tag);
            source.setPrefix(th.getPrefix()).setSuffix(th.getSuffix());
            return ConditContext.doBuildSqlInfo(source, th);
        }
        throw new NodeNotFoundException("\u672a\u627e\u5230\u6807\u7b7e\u5bf9\u5e94\u7684\u5904\u7406\u5668\uff0c\u8be5\u6807\u7b7e\u4e3a:<" + tag + ">");
    }

    private static SqlInfo doBuildSqlInfo(BuildSource source, TagHandler th) {
        try {
            IConditHandler handler = th.getHandlerCls().newInstance();
            return handler.buildSqlInfo(source);
        }
        catch (InstantiationException e) {
            log.error("\u5b9e\u4f8b\u5316IConditHandler\u7684\u5b9e\u73b0\u7c7b\u51fa\u9519!", e);
        }
        catch (IllegalAccessException e) {
            log.error("\u8bbf\u95eeHandler\u7684\u5b9e\u73b0\u7c7b\u51fa\u9519!", e);
        }
        return source.getSqlInfo();
    }
}

