/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.config.AbstractZealotConfig;
import com.blinkfox.zealot.config.entity.NormalConfig;
import com.blinkfox.zealot.core.ConditContext;
import com.blinkfox.zealot.exception.NodeNotFoundException;
import com.blinkfox.zealot.exception.ValidFailException;
import com.blinkfox.zealot.helpers.ParseHelper;
import com.blinkfox.zealot.helpers.SqlInfoPrinter;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.helpers.XmlNodeHelper;
import java.util.List;
import org.dom4j.Node;

public final class Zealot {
    private static final int LEN = 2;

    private Zealot() {
    }

    public static SqlInfo getSqlInfoSimply(String nsAtZealotId) {
        return Zealot.getSqlInfoSimply(nsAtZealotId, null);
    }

    public static SqlInfo getSqlInfoSimply(String nsAtZealotId, Object paramObj) {
        String[] arr = nsAtZealotId.split("@@");
        if (arr.length != 2) {
            throw new ValidFailException("nsAtZealotId\u53c2\u6570\u7684\u503c\u5fc5\u987b\u662fxml\u6587\u4ef6\u4e2d\u7684 nameSpace + '@@' + zealotId \u8282\u70b9\u7684\u503c\uff0c\u5982:'student@@queryStudentById'.\u5176\u4e2dstudent\u4e3anameSpace, queryStudentById\u4e3aXML\u6587\u4ef6\u4e2dSQL\u7684zealotId.");
        }
        return Zealot.getSqlInfo(arr[0], arr[1], paramObj);
    }

    public static SqlInfo getSqlInfo(String nameSpace, String zealotId) {
        return Zealot.getSqlInfo(nameSpace, zealotId, null);
    }

    public static SqlInfo getSqlInfo(String nameSpace, String zealotId, Object paramObj) {
        Node zealotNode;
        if (StringHelper.isBlank(nameSpace) || StringHelper.isBlank(zealotId)) {
            throw new ValidFailException("\u8bf7\u8f93\u5165\u6709\u6548\u7684nameSpace\u6216\u8005zealotId\u7684\u503c!");
        }
        Node node = zealotNode = NormalConfig.getInstance().isDebug() ? XmlNodeHelper.getNodeBySpaceAndId(nameSpace, zealotId) : AbstractZealotConfig.getZealots().get(StringHelper.concat(nameSpace, "@@", zealotId));
        if (zealotNode == null) {
            throw new NodeNotFoundException("\u672a\u627e\u5230nameSpace\u4e3a:" + nameSpace + ",zealotId\u4e3a:" + zealotId + "\u7684\u8282\u70b9!");
        }
        SqlInfo sqlInfo = Zealot.buildNewSqlInfo(nameSpace, zealotNode, paramObj);
        SqlInfoPrinter.newInstance().printZealotSqlInfo(sqlInfo, true, nameSpace, zealotId);
        return sqlInfo;
    }

    public static SqlInfo buildSqlInfo(String nameSpace, SqlInfo sqlInfo, Node node, Object paramObj) {
        List nodes = node.selectNodes("child::node()");
        for (Node n : nodes) {
            if ("Text".equals(n.getNodeTypeName())) {
                sqlInfo.getJoin().append(n.getText());
                continue;
            }
            if (!"Element".equals(n.getNodeTypeName())) continue;
            ConditContext.buildSqlInfo(new BuildSource(nameSpace, sqlInfo, n, paramObj), n.getName());
        }
        return Zealot.buildFinalSql(sqlInfo, paramObj);
    }

    private static SqlInfo buildNewSqlInfo(String nameSpace, Node node, Object paramObj) {
        return Zealot.buildSqlInfo(nameSpace, SqlInfo.newInstance(), node, paramObj);
    }

    private static SqlInfo buildFinalSql(SqlInfo sqlInfo, Object paramObj) {
        String sql = sqlInfo.getJoin().toString();
        sql = ParseHelper.parseTemplate(sql, paramObj);
        return sqlInfo.setSql(StringHelper.replaceBlank(sql));
    }
}

