/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.core.ICustomAction;
import com.blinkfox.zealot.core.builder.JavaSqlInfoBuilder;
import com.blinkfox.zealot.core.builder.SqlInfoBuilder;
import com.blinkfox.zealot.exception.NotCollectionOrArrayException;
import com.blinkfox.zealot.helpers.CollectionHelper;
import com.blinkfox.zealot.helpers.SqlInfoPrinter;
import com.blinkfox.zealot.helpers.StringHelper;
import java.util.Collection;
import java.util.Collections;

public final class ZealotKhala {
    private BuildSource source = new BuildSource(SqlInfo.newInstance());

    private ZealotKhala() {
    }

    public static ZealotKhala start() {
        return new ZealotKhala();
    }

    public SqlInfo end() {
        SqlInfo sqlInfo = this.source.getSqlInfo();
        sqlInfo.setSql(StringHelper.replaceBlank(sqlInfo.getJoin().toString()));
        SqlInfoPrinter.newInstance().printZealotSqlInfo(sqlInfo, false, null, null);
        return sqlInfo;
    }

    private ZealotKhala concat(String sqlKey, String ... params) {
        this.source.getSqlInfo().getJoin().append(" ").append(sqlKey).append(" ");
        if (params != null && params.length > 0) {
            for (String s : params) {
                this.source.getSqlInfo().getJoin().append(s).append(" ");
            }
        }
        return this;
    }

    public ZealotKhala insertInto(String text) {
        return this.concat("INSERT INTO", text);
    }

    public ZealotKhala values(String text) {
        return this.concat("VALUES", text);
    }

    public ZealotKhala deleteFrom(String text) {
        return this.concat("DELETE FROM", text);
    }

    public ZealotKhala update(String text) {
        return this.concat("UPDATE", text);
    }

    public ZealotKhala select(String text) {
        return this.concat("SELECT", text);
    }

    public ZealotKhala from(String text) {
        return this.concat("FROM", text);
    }

    public ZealotKhala where(String text, Object ... value) {
        this.concat("WHERE", text);
        return this.param(value);
    }

    public ZealotKhala and(String text) {
        return this.concat("AND", text);
    }

    public ZealotKhala or(String text) {
        return this.concat("OR", text);
    }

    public ZealotKhala as(String text) {
        return this.concat("AS", text);
    }

    public ZealotKhala set(String text) {
        return this.concat("SET", text);
    }

    public ZealotKhala innerJoin(String text) {
        return this.concat("INNER JOIN", text);
    }

    public ZealotKhala leftJoin(String text) {
        return this.concat("LEFT JOIN", text);
    }

    public ZealotKhala rightJoin(String text) {
        return this.concat("RIGHT JOIN", text);
    }

    public ZealotKhala fullJoin(String text) {
        return this.concat("FULL JOIN", text);
    }

    public ZealotKhala on(String text) {
        return this.concat("ON", text);
    }

    public ZealotKhala orderBy(String text) {
        return this.concat("ORDER BY", text);
    }

    public ZealotKhala groupBy(String text) {
        return this.concat("GROUP BY", text);
    }

    public ZealotKhala having(String text) {
        return this.concat("HAVING", text);
    }

    public ZealotKhala limit(String text) {
        return this.concat("LIMIT", text);
    }

    public ZealotKhala offset(String text) {
        return this.concat("OFFSET", text);
    }

    public ZealotKhala asc() {
        return this.concat("ASC", new String[0]);
    }

    public ZealotKhala desc() {
        return this.concat("DESC", new String[0]);
    }

    public ZealotKhala union() {
        return this.concat("UNION", new String[0]);
    }

    public ZealotKhala unionAll() {
        return this.concat("UNION ALL", new String[0]);
    }

    public ZealotKhala text(String text, Object ... values) {
        this.source.getSqlInfo().getJoin().append(text);
        this.appendParams(values, 1);
        return this;
    }

    public ZealotKhala text(boolean match, String text, Object ... values) {
        return match ? this.text(text, values) : this;
    }

    private ZealotKhala appendParams(Object value, int objType) {
        Object[] values = CollectionHelper.toArray(value, objType);
        if (CollectionHelper.isNotEmpty(values)) {
            Collections.addAll(this.source.getSqlInfo().getParams(), values);
        }
        return this;
    }

    public ZealotKhala param(Object ... values) {
        return this.appendParams(values, 1);
    }

    public ZealotKhala param(Collection<?> values) {
        return this.appendParams(values, 2);
    }

    public ZealotKhala doAnything(ICustomAction action) {
        SqlInfo sqlInfo = this.source.getSqlInfo();
        action.execute(sqlInfo.getJoin(), sqlInfo.getParams());
        return this;
    }

    public ZealotKhala doAnything(boolean match, ICustomAction action) {
        return match ? this.doAnything(action) : this;
    }

    private ZealotKhala doNormal(String prefix, String field, Object value, String suffix, boolean match) {
        if (match) {
            SqlInfoBuilder.newInstace(this.source.setPrefix(prefix)).buildNormalSql(field, value, suffix);
            this.source.resetPrefix();
        }
        return this;
    }

    private ZealotKhala doLike(String prefix, String field, Object value, boolean match, boolean positive) {
        if (match) {
            String suffix = positive ? " LIKE " : " NOT LIKE ";
            SqlInfoBuilder.newInstace(this.source.setPrefix(prefix).setSuffix(suffix)).buildLikeSql(field, value);
            this.source.resetPrefix();
        }
        return this;
    }

    private ZealotKhala doLikePattern(String prefix, String field, String pattern, boolean match, boolean positive) {
        if (match) {
            String suffix = positive ? " LIKE " : " NOT LIKE ";
            SqlInfoBuilder.newInstace(this.source.setPrefix(prefix).setSuffix(suffix)).buildLikePatternSql(field, pattern);
            this.source.resetPrefix();
        }
        return this;
    }

    private ZealotKhala doBetween(String prefix, String field, Object startValue, Object endValue, boolean match) {
        if (match) {
            SqlInfoBuilder.newInstace(this.source.setPrefix(prefix)).buildBetweenSql(field, startValue, endValue);
            this.source.resetPrefix();
        }
        return this;
    }

    private ZealotKhala doInByType(String prefix, String field, Object value, boolean match, int objType, boolean positive) {
        if (match) {
            this.source.setPrefix(prefix).setSuffix(positive ? " IN " : " NOT IN ");
            switch (objType) {
                case 1: {
                    SqlInfoBuilder.newInstace(this.source).buildInSql(field, (Object[])value);
                    break;
                }
                case 2: {
                    JavaSqlInfoBuilder.newInstace(this.source).buildInSqlByCollection(field, (Collection)value);
                    break;
                }
                default: {
                    throw new NotCollectionOrArrayException("in\u67e5\u8be2\u7684\u503c\u4e0d\u662f\u6709\u6548\u7684\u96c6\u5408\u6216\u6570\u7ec4!");
                }
            }
            this.source.resetPrefix();
        }
        return this;
    }

    private ZealotKhala doIn(String prefix, String field, Object[] values, boolean match, boolean positive) {
        return this.doInByType(prefix, field, values, match, 1, positive);
    }

    private ZealotKhala doIn(String prefix, String field, Collection<?> values, boolean match, boolean positive) {
        return this.doInByType(prefix, field, values, match, 2, positive);
    }

    private ZealotKhala doIsNull(String prefix, String field, boolean match, boolean positive) {
        if (match) {
            this.source = this.source.setPrefix(prefix).setSuffix(positive ? " IS NULL " : " IS NOT NULL ");
            SqlInfoBuilder.newInstace(this.source).buildIsNullSql(field);
            this.source.resetPrefix();
        }
        return this;
    }

    public ZealotKhala equal(String field, Object value) {
        return this.doNormal(" ", field, value, " = ? ", true);
    }

    public ZealotKhala equal(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " = ? ", match);
    }

    public ZealotKhala andEqual(String field, Object value) {
        return this.doNormal(" AND ", field, value, " = ? ", true);
    }

    public ZealotKhala andEqual(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " = ? ", match);
    }

    public ZealotKhala orEqual(String field, Object value) {
        return this.doNormal(" OR ", field, value, " = ? ", true);
    }

    public ZealotKhala orEqual(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " = ? ", match);
    }

    public ZealotKhala notEqual(String field, Object value) {
        return this.doNormal(" ", field, value, " <> ? ", true);
    }

    public ZealotKhala notEqual(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " <> ? ", match);
    }

    public ZealotKhala andNotEqual(String field, Object value) {
        return this.doNormal(" AND ", field, value, " <> ? ", true);
    }

    public ZealotKhala andNotEqual(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " <> ? ", match);
    }

    public ZealotKhala orNotEqual(String field, Object value) {
        return this.doNormal(" OR ", field, value, " <> ? ", true);
    }

    public ZealotKhala orNotEqual(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " <> ? ", match);
    }

    public ZealotKhala moreThan(String field, Object value) {
        return this.doNormal(" ", field, value, " > ? ", true);
    }

    public ZealotKhala moreThan(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " > ? ", match);
    }

    public ZealotKhala andMoreThan(String field, Object value) {
        return this.doNormal(" AND ", field, value, " > ? ", true);
    }

    public ZealotKhala andMoreThan(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " > ? ", match);
    }

    public ZealotKhala orMoreThan(String field, Object value) {
        return this.doNormal(" OR ", field, value, " > ? ", true);
    }

    public ZealotKhala orMoreThan(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " > ? ", match);
    }

    public ZealotKhala lessThan(String field, Object value) {
        return this.doNormal(" ", field, value, " < ? ", true);
    }

    public ZealotKhala lessThan(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " < ? ", match);
    }

    public ZealotKhala andLessThan(String field, Object value) {
        return this.doNormal(" AND ", field, value, " < ? ", true);
    }

    public ZealotKhala andLessThan(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " < ? ", match);
    }

    public ZealotKhala orLessThan(String field, Object value) {
        return this.doNormal(" OR ", field, value, " < ? ", true);
    }

    public ZealotKhala orLessThan(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " < ? ", match);
    }

    public ZealotKhala moreEqual(String field, Object value) {
        return this.doNormal(" ", field, value, " >= ? ", true);
    }

    public ZealotKhala moreEqual(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " >= ? ", match);
    }

    public ZealotKhala andMoreEqual(String field, Object value) {
        return this.doNormal(" AND ", field, value, " >= ? ", true);
    }

    public ZealotKhala andMoreEqual(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " >= ? ", match);
    }

    public ZealotKhala orMoreEqual(String field, Object value) {
        return this.doNormal(" OR ", field, value, " >= ? ", true);
    }

    public ZealotKhala orMoreEqual(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " >= ? ", match);
    }

    public ZealotKhala lessEqual(String field, Object value) {
        return this.doNormal(" ", field, value, " <= ? ", true);
    }

    public ZealotKhala lessEqual(String field, Object value, boolean match) {
        return this.doNormal(" ", field, value, " <= ? ", match);
    }

    public ZealotKhala andLessEqual(String field, Object value) {
        return this.doNormal(" AND ", field, value, " <= ? ", true);
    }

    public ZealotKhala andLessEqual(String field, Object value, boolean match) {
        return this.doNormal(" AND ", field, value, " <= ? ", match);
    }

    public ZealotKhala orLessEqual(String field, Object value) {
        return this.doNormal(" OR ", field, value, " <= ? ", true);
    }

    public ZealotKhala orLessEqual(String field, Object value, boolean match) {
        return this.doNormal(" OR ", field, value, " <= ? ", match);
    }

    public ZealotKhala like(String field, Object value) {
        return this.doLike(" ", field, value, true, true);
    }

    public ZealotKhala like(String field, Object value, boolean match) {
        return this.doLike(" ", field, value, match, true);
    }

    public ZealotKhala andLike(String field, Object value) {
        return this.doLike(" AND ", field, value, true, true);
    }

    public ZealotKhala andLike(String field, Object value, boolean match) {
        return this.doLike(" AND ", field, value, match, true);
    }

    public ZealotKhala orLike(String field, Object value) {
        return this.doLike(" OR ", field, value, true, true);
    }

    public ZealotKhala orLike(String field, Object value, boolean match) {
        return this.doLike(" OR ", field, value, match, true);
    }

    public ZealotKhala notLike(String field, Object value) {
        return this.doLike(" ", field, value, true, false);
    }

    public ZealotKhala notLike(String field, Object value, boolean match) {
        return this.doLike(" ", field, value, match, false);
    }

    public ZealotKhala andNotLike(String field, Object value) {
        return this.doLike(" AND ", field, value, true, false);
    }

    public ZealotKhala andNotLike(String field, Object value, boolean match) {
        return this.doLike(" AND ", field, value, match, false);
    }

    public ZealotKhala orNotLike(String field, Object value) {
        return this.doLike(" OR ", field, value, true, false);
    }

    public ZealotKhala orNotLike(String field, Object value, boolean match) {
        return this.doLike(" OR ", field, value, match, false);
    }

    public ZealotKhala likePattern(String field, String pattern) {
        return this.doLikePattern(" ", field, pattern, true, true);
    }

    public ZealotKhala likePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" ", field, pattern, match, true);
    }

    public ZealotKhala andLikePattern(String field, String pattern) {
        return this.doLikePattern(" AND ", field, pattern, true, true);
    }

    public ZealotKhala andLikePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" AND ", field, pattern, match, true);
    }

    public ZealotKhala orLikePattern(String field, String pattern) {
        return this.doLikePattern(" OR ", field, pattern, true, true);
    }

    public ZealotKhala orLikePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" OR ", field, pattern, match, true);
    }

    public ZealotKhala notLikePattern(String field, String pattern) {
        return this.doLikePattern(" ", field, pattern, true, false);
    }

    public ZealotKhala notLikePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" ", field, pattern, match, false);
    }

    public ZealotKhala andNotLikePattern(String field, String pattern) {
        return this.doLikePattern(" AND ", field, pattern, true, false);
    }

    public ZealotKhala andNotLikePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" AND ", field, pattern, match, false);
    }

    public ZealotKhala orNotLikePattern(String field, String pattern) {
        return this.doLikePattern(" OR ", field, pattern, true, false);
    }

    public ZealotKhala orNotLikePattern(String field, String pattern, boolean match) {
        return this.doLikePattern(" OR ", field, pattern, match, false);
    }

    public ZealotKhala between(String field, Object startValue, Object endValue) {
        return this.doBetween(" ", field, startValue, endValue, true);
    }

    public ZealotKhala between(String field, Object startValue, Object endValue, boolean match) {
        return this.doBetween(" ", field, startValue, endValue, match);
    }

    public ZealotKhala andBetween(String field, Object startValue, Object endValue) {
        return this.doBetween(" AND ", field, startValue, endValue, true);
    }

    public ZealotKhala andBetween(String field, Object startValue, Object endValue, boolean match) {
        return this.doBetween(" AND ", field, startValue, endValue, match);
    }

    public ZealotKhala orBetween(String field, Object startValue, Object endValue) {
        return this.doBetween(" OR ", field, startValue, endValue, true);
    }

    public ZealotKhala orBetween(String field, Object startValue, Object endValue, boolean match) {
        return this.doBetween(" OR ", field, startValue, endValue, match);
    }

    public ZealotKhala in(String field, Object[] values) {
        return this.doIn(" ", field, values, true, true);
    }

    public ZealotKhala in(String field, Object[] values, boolean match) {
        return this.doIn(" ", field, values, match, true);
    }

    public ZealotKhala in(String field, Collection<?> values) {
        return this.doIn(" ", field, values, true, true);
    }

    public ZealotKhala in(String field, Collection<?> values, boolean match) {
        return this.doIn(" ", field, values, match, true);
    }

    public ZealotKhala andIn(String field, Object[] values) {
        return this.doIn(" AND ", field, values, true, true);
    }

    public ZealotKhala andIn(String field, Object[] values, boolean match) {
        return this.doIn(" AND ", field, values, match, true);
    }

    public ZealotKhala andIn(String field, Collection<?> values) {
        return this.doIn(" AND ", field, values, true, true);
    }

    public ZealotKhala andIn(String field, Collection<?> values, boolean match) {
        return this.doIn(" AND ", field, values, match, true);
    }

    public ZealotKhala orIn(String field, Object[] values) {
        return this.doIn(" OR ", field, values, true, true);
    }

    public ZealotKhala orIn(String field, Object[] values, boolean match) {
        return this.doIn(" OR ", field, values, match, true);
    }

    public ZealotKhala orIn(String field, Collection<?> values) {
        return this.doIn(" OR ", field, values, true, true);
    }

    public ZealotKhala orIn(String field, Collection<?> values, boolean match) {
        return this.doIn(" OR ", field, values, match, true);
    }

    public ZealotKhala notIn(String field, Object[] values) {
        return this.doIn(" ", field, values, true, false);
    }

    public ZealotKhala notIn(String field, Object[] values, boolean match) {
        return this.doIn(" ", field, values, match, false);
    }

    public ZealotKhala notIn(String field, Collection<?> values) {
        return this.doIn(" ", field, values, true, false);
    }

    public ZealotKhala notIn(String field, Collection<?> values, boolean match) {
        return this.doIn(" ", field, values, match, false);
    }

    public ZealotKhala andNotIn(String field, Object[] values) {
        return this.doIn(" AND ", field, values, true, false);
    }

    public ZealotKhala andNotIn(String field, Object[] values, boolean match) {
        return this.doIn(" AND ", field, values, match, false);
    }

    public ZealotKhala andNotIn(String field, Collection<?> values) {
        return this.doIn(" AND ", field, values, true, false);
    }

    public ZealotKhala andNotIn(String field, Collection<?> values, boolean match) {
        return this.doIn(" AND ", field, values, match, false);
    }

    public ZealotKhala orNotIn(String field, Object[] values) {
        return this.doIn(" OR ", field, values, true, false);
    }

    public ZealotKhala orNotIn(String field, Object[] values, boolean match) {
        return this.doIn(" OR ", field, values, match, false);
    }

    public ZealotKhala orNotIn(String field, Collection<?> values) {
        return this.doIn(" OR ", field, values, true, false);
    }

    public ZealotKhala orNotIn(String field, Collection<?> values, boolean match) {
        return this.doIn(" OR ", field, values, match, false);
    }

    public ZealotKhala isNull(String field) {
        return this.doIsNull(" ", field, true, true);
    }

    public ZealotKhala isNull(String field, boolean match) {
        return this.doIsNull(" ", field, match, true);
    }

    public ZealotKhala andIsNull(String field) {
        return this.doIsNull(" AND ", field, true, true);
    }

    public ZealotKhala andIsNull(String field, boolean match) {
        return this.doIsNull(" AND ", field, match, true);
    }

    public ZealotKhala orIsNull(String field) {
        return this.doIsNull(" OR ", field, true, true);
    }

    public ZealotKhala orIsNull(String field, boolean match) {
        return this.doIsNull(" OR ", field, match, true);
    }

    public ZealotKhala isNotNull(String field) {
        return this.doIsNull(" ", field, true, false);
    }

    public ZealotKhala isNotNull(String field, boolean match) {
        return this.doIsNull(" ", field, match, false);
    }

    public ZealotKhala andIsNotNull(String field) {
        return this.doIsNull(" AND ", field, true, false);
    }

    public ZealotKhala andIsNotNull(String field, boolean match) {
        return this.doIsNull(" AND ", field, match, false);
    }

    public ZealotKhala orIsNotNull(String field) {
        return this.doIsNull(" OR ", field, true, false);
    }

    public ZealotKhala orIsNotNull(String field, boolean match) {
        return this.doIsNull(" OR ", field, match, false);
    }
}

