/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core.builder;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.helpers.StringHelper;
import java.util.List;

public class SqlInfoBuilder {
    SqlInfo sqlInfo;
    private StringBuilder join;
    private List<Object> params;
    Object context;
    private String prefix;
    private String suffix;

    SqlInfoBuilder() {
    }

    public static SqlInfoBuilder newInstace(BuildSource source) {
        SqlInfoBuilder builder = new SqlInfoBuilder();
        builder.init(source);
        return builder;
    }

    void init(BuildSource source) {
        this.sqlInfo = source.getSqlInfo();
        this.join = this.sqlInfo.getJoin();
        this.params = this.sqlInfo.getParams();
        this.context = source.getParamObj();
        this.prefix = source.getPrefix();
        this.suffix = source.getSuffix();
    }

    public SqlInfo buildNormalSql(String fieldText, Object value, String suffix) {
        this.join.append(this.prefix).append(fieldText).append(suffix);
        this.params.add(value);
        return this.sqlInfo.setJoin(this.join).setParams(this.params);
    }

    public SqlInfo buildLikeSql(String fieldText, Object value) {
        this.suffix = StringHelper.isBlank(this.suffix) ? " LIKE " : this.suffix;
        this.join.append(this.prefix).append(fieldText).append(this.suffix).append("? ");
        this.params.add("%" + value + "%");
        return this.sqlInfo.setJoin(this.join).setParams(this.params);
    }

    public SqlInfo buildLikePatternSql(String fieldText, String pattern) {
        this.suffix = StringHelper.isBlank(this.suffix) ? " LIKE " : this.suffix;
        this.join.append(this.prefix).append(fieldText).append(this.suffix).append("'").append(pattern).append("' ");
        return this.sqlInfo.setJoin(this.join);
    }

    public SqlInfo buildBetweenSql(String fieldText, Object startValue, Object endValue) {
        if (startValue != null && endValue == null) {
            this.join.append(this.prefix).append(fieldText).append(" >= ? ");
            this.params.add(startValue);
        } else if (startValue == null && endValue != null) {
            this.join.append(this.prefix).append(fieldText).append(" <= ? ");
            this.params.add(endValue);
        } else {
            this.join.append(this.prefix).append(fieldText).append(" BETWEEN ? AND ? ");
            this.params.add(startValue);
            this.params.add(endValue);
        }
        return this.sqlInfo.setJoin(this.join).setParams(this.params);
    }

    public SqlInfo buildInSql(String fieldText, Object[] values) {
        if (values == null || values.length == 0) {
            return this.sqlInfo;
        }
        this.suffix = StringHelper.isBlank(this.suffix) ? " IN " : this.suffix;
        this.join.append(this.prefix).append(fieldText).append(this.suffix).append("(");
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                this.join.append("?) ");
            } else {
                this.join.append("?, ");
            }
            this.params.add(values[i]);
        }
        return this.sqlInfo.setJoin(this.join).setParams(this.params);
    }

    public SqlInfo buildIsNullSql(String fieldText) {
        this.suffix = StringHelper.isBlank(this.suffix) ? " IS NULL " : this.suffix;
        this.join.append(this.prefix).append(fieldText).append(this.suffix);
        return this.sqlInfo.setJoin(this.join);
    }
}

