/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core.builder;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.core.builder.SqlInfoBuilder;
import com.blinkfox.zealot.exception.ValidFailException;
import com.blinkfox.zealot.helpers.ParseHelper;
import com.blinkfox.zealot.helpers.StringHelper;
import java.util.Collection;

public final class XmlSqlInfoBuilder
extends SqlInfoBuilder {
    private XmlSqlInfoBuilder() {
    }

    public static XmlSqlInfoBuilder newInstace(BuildSource source) {
        XmlSqlInfoBuilder builder = new XmlSqlInfoBuilder();
        builder.init(source);
        return builder;
    }

    public SqlInfo buildNormalSql(String fieldText, String valueText, String suffix) {
        Object value = ParseHelper.parseExpressWithException(valueText, this.context);
        return super.buildNormalSql(fieldText, value, suffix);
    }

    public SqlInfo buildLikeSql(String fieldText, String valueText, String patternText) {
        if (StringHelper.isNotBlank(valueText) && StringHelper.isBlank(patternText)) {
            return super.buildLikeSql(fieldText, ParseHelper.parseExpressWithException(valueText, this.context));
        }
        if (StringHelper.isBlank(valueText) && StringHelper.isNotBlank(patternText)) {
            return super.buildLikePatternSql(fieldText, patternText);
        }
        throw new ValidFailException("<like /> \u6807\u7b7e\u4e2d\u7684'value'\u5c5e\u6027\u548c'pattern'\u5c5e\u6027\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u8005\u540c\u65f6\u4e0d\u4e3a\u7a7a\uff01");
    }

    public SqlInfo buildBetweenSql(String fieldText, String startText, String endText) {
        Object startValue = ParseHelper.parseExpress(startText, this.context);
        Object endValue = ParseHelper.parseExpress(endText, this.context);
        return super.buildBetweenSql(fieldText, startValue, endValue);
    }

    public SqlInfo buildInSql(String fieldText, String valueText) {
        Object obj = ParseHelper.parseExpressWithException(valueText, this.context);
        if (obj == null) {
            return this.sqlInfo;
        }
        Object[] values = this.convertToArray(obj);
        return super.buildInSql(fieldText, values);
    }

    public SqlInfo buildTextSqlParams(String valueText) {
        Object[] values;
        Object obj = ParseHelper.parseExpressWithException(valueText, this.context);
        obj = obj == null ? new Object(){} : obj;
        for (Object objVal : values = this.convertToArray(obj)) {
            this.sqlInfo.getParams().add(objVal);
        }
        return this.sqlInfo;
    }

    private Object[] convertToArray(Object obj) {
        Object[] values = obj instanceof Collection ? ((Collection)obj).toArray() : (obj.getClass().isArray() ? (Object[])obj : new Object[]{obj});
        return values;
    }
}

