/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.core.concrete;

import com.blinkfox.zealot.bean.BuildSource;
import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.core.IConditHandler;
import com.blinkfox.zealot.core.builder.XmlSqlInfoBuilder;
import com.blinkfox.zealot.exception.ContainXmlTagException;
import com.blinkfox.zealot.helpers.ParseHelper;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.helpers.XmlNodeHelper;
import java.util.List;
import org.dom4j.Node;

public class TextHandler
implements IConditHandler {
    @Override
    public SqlInfo buildSqlInfo(BuildSource source) {
        String valueText = XmlNodeHelper.getNodeAttrText(source.getNode(), "attribute::value");
        String matchText = XmlNodeHelper.getNodeAttrText(source.getNode(), "attribute::match");
        if (StringHelper.isBlank(matchText)) {
            return this.doBuildSqlInfo(source, valueText);
        }
        Boolean isTrue = (Boolean)ParseHelper.parseExpressWithException(matchText, source.getParamObj());
        if (isTrue.booleanValue()) {
            return this.doBuildSqlInfo(source, valueText);
        }
        return source.getSqlInfo();
    }

    private SqlInfo doBuildSqlInfo(BuildSource source, String valueText) {
        SqlInfo sqlInfo = source.getSqlInfo();
        Node node = source.getNode();
        this.concatSqlText(node, sqlInfo);
        return XmlSqlInfoBuilder.newInstace(source).buildTextSqlParams(valueText);
    }

    private void concatSqlText(Node node, SqlInfo sqlInfo) {
        List nodes = node.selectNodes("child::node()");
        for (Node n : nodes) {
            if ("Text".equals(n.getNodeTypeName())) {
                sqlInfo.getJoin().append(n.getText());
                continue;
            }
            throw new ContainXmlTagException("<text></text>\u6807\u7b7e\u4e2d\u4e0d\u80fd\u5305\u542b\u5176\u4ed6xml\u6807\u7b7e\uff0c\u53ea\u80fd\u662f\u6587\u672c\u5143\u7d20\uff01");
        }
    }
}

