/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.helpers;

import com.blinkfox.zealot.exception.ParseExpressionException;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.log.Log;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

public final class ParseHelper {
    private static final Log log = Log.get(ParseHelper.class);

    private ParseHelper() {
    }

    public static Object parseExpress(String exp, Object paramObj) {
        try {
            return MVEL.eval((String)exp, (Object)paramObj);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8868\u8fbe\u5f0f\u51fa\u9519,\u8868\u8fbe\u5f0f\u4e3a:" + exp, e);
            return null;
        }
    }

    public static Object parseExpressWithException(String exp, Object paramObj) {
        Object obj;
        try {
            obj = MVEL.eval((String)exp, (Object)paramObj);
        }
        catch (Exception e) {
            throw new ParseExpressionException("\u89e3\u6790Mvel\u8868\u8fbe\u5f0f\u5f02\u5e38\uff0c\u89e3\u6790\u51fa\u9519\u7684\u8868\u8fbe\u5f0f\u4e3a:" + exp, e);
        }
        return obj;
    }

    public static String parseTemplate(String template, Object paramObj) {
        String output;
        try {
            output = (String)TemplateRuntime.eval((String)template, (Object)paramObj);
        }
        catch (Exception e) {
            throw new ParseExpressionException("\u89e3\u6790Mvel\u6a21\u677f\u5f02\u5e38\uff0c\u89e3\u6790\u51fa\u9519\u7684\u6a21\u677f\u4e3a:" + template, e);
        }
        return output;
    }

    public static boolean isMatch(String match, Object paramObj) {
        return StringHelper.isBlank(match) || ParseHelper.isTrue(match, paramObj);
    }

    public static boolean isNotMatch(String match, Object paramObj) {
        return !ParseHelper.isMatch(match, paramObj);
    }

    public static boolean isTrue(String exp, Object paramObj) {
        return Boolean.TRUE.equals(ParseHelper.parseExpressWithException(exp, paramObj));
    }
}

