/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.helpers;

import com.blinkfox.zealot.bean.SqlInfo;
import com.blinkfox.zealot.config.entity.NormalConfig;
import com.blinkfox.zealot.config.entity.XmlContext;
import com.blinkfox.zealot.log.Log;
import java.util.Arrays;

public class SqlInfoPrinter {
    private static final Log log = Log.get(SqlInfoPrinter.class);
    private static final String PRINT_START = "------------------------------------------------------------ Zealot\u751f\u6210\u7684SQL\u4fe1\u606f ---------------------------------------------------------";
    private static final String PRINT_END = "-----------------------------------------------------------------------------------------------------------------------------------------";
    private static final String LINE_BREAK = "\n";

    private SqlInfoPrinter() {
    }

    public static SqlInfoPrinter newInstance() {
        return new SqlInfoPrinter();
    }

    public void printZealotSqlInfo(SqlInfo sqlInfo, boolean hasXml, String nameSpace, String zealotId) {
        if (NormalConfig.getInstance().isPrintSqlInfo()) {
            StringBuilder sb = new StringBuilder(LINE_BREAK);
            sb.append(PRINT_START).append(LINE_BREAK);
            if (hasXml) {
                sb.append("--zealot xml: ").append(XmlContext.INSTANCE.getXmlPathMap().get(nameSpace)).append(" -> ").append(zealotId).append(LINE_BREAK);
            }
            sb.append("-------- SQL: ").append(sqlInfo.getSql()).append(LINE_BREAK).append("----- Params: ").append(Arrays.toString(sqlInfo.getParamsArr())).append(LINE_BREAK);
            sb.append(PRINT_END).append(LINE_BREAK);
            log.info(sb.toString());
        }
    }
}

