/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringHelper {
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\|\t|\r|\n");
    private static final String XML_EXT = ".xml";
    private static final String JAVA_EXT = ".java";
    private static final String CLASS_EXT = ".class";

    private StringHelper() {
    }

    public static String replaceBlank(String str) {
        Matcher m = BLANK_PATTERN.matcher(str);
        return m.replaceAll("").replaceAll("\\s{2,}", " ").trim();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringHelper.isBlank(str);
    }

    public static String concat(String ... strs) {
        StringBuilder sb = new StringBuilder("");
        for (String str : strs) {
            sb.append(str);
        }
        return sb.toString();
    }

    private static boolean isExtFile(String filePath, String ext) {
        return filePath != null && filePath.endsWith(ext);
    }

    public static boolean isXmlFile(String filePath) {
        return StringHelper.isExtFile(filePath, XML_EXT);
    }

    public static boolean isJavaFile(String filePath) {
        return StringHelper.isExtFile(filePath, JAVA_EXT);
    }

    public static boolean isClassFile(String filePath) {
        return StringHelper.isExtFile(filePath, CLASS_EXT);
    }
}

