/*
 * Decompiled with CFR 0.152.
 */
package com.blinkfox.zealot.helpers;

import com.blinkfox.zealot.config.ZealotConfigManager;
import com.blinkfox.zealot.config.entity.XmlContext;
import com.blinkfox.zealot.exception.FieldEmptyException;
import com.blinkfox.zealot.exception.XmlParseException;
import com.blinkfox.zealot.helpers.StringHelper;
import com.blinkfox.zealot.log.Log;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class XmlNodeHelper {
    private static final Log log = Log.get(ZealotConfigManager.class);
    private static final String ROOT_NAME = "zealots";

    private XmlNodeHelper() {
    }

    public static Document getDocument(String xmlPath) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            return new SAXReader().read(is);
        }
        catch (Exception e) {
            throw new XmlParseException("\u8bfb\u53d6\u6216\u89e3\u6790xml\u6587\u4ef6\u5931\u8d25\uff0cxmlPath\u662f:" + xmlPath, e);
        }
    }

    public static Node getNodeBySpaceAndId(String nameSpace, String zealotId) {
        String filePath = XmlContext.INSTANCE.getXmlPathMap().get(nameSpace);
        Document doc = XmlNodeHelper.getDocument(filePath);
        return doc == null ? null : XmlNodeHelper.getZealotNodeById(doc, zealotId);
    }

    public static String getZealotXmlNameSpace(String xmlPath) {
        Document doc;
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath);
            doc = new SAXReader().read(is);
        }
        catch (Exception expected) {
            log.warn("\u89e3\u6790\u8def\u5f84\u4e3a:'" + xmlPath + "'\u7684xml\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u5176\u6b63\u786e\u6027");
            return null;
        }
        Element root = doc.getRootElement();
        if (root != null && ROOT_NAME.equals(root.getName())) {
            String nameSpace = XmlNodeHelper.getNodeText(root.selectSingleNode("attribute::nameSpace"));
            if (StringHelper.isBlank(nameSpace)) {
                log.warn("zealot xml\u6587\u4ef6:'" + xmlPath + "'\u7684\u6839\u8282\u70b9nameSpace\u547d\u540d\u7a7a\u95f4\u5c5e\u6027\u4e3a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\uff0c\u5426\u5219\u5c06\u88ab\u5ffd\u7565!");
                return null;
            }
            return nameSpace;
        }
        return null;
    }

    public static Node getZealotNodeById(Document doc, String id) {
        return doc.selectSingleNode("/zealots/zealot[@id='" + id + "']");
    }

    public static String getNodeText(Node node) {
        return node == null ? "" : node.getText();
    }

    public static String getNodeAttrText(Node node, String attrName) {
        Node fieldNode = node.selectSingleNode(attrName);
        return XmlNodeHelper.getNodeText(fieldNode);
    }

    public static String getAndCheckNodeText(Node node, String nodeName) {
        Node fieldNode = node.selectSingleNode(nodeName);
        String fieldText = XmlNodeHelper.getNodeText(fieldNode);
        if (StringHelper.isBlank(fieldText)) {
            throw new FieldEmptyException("\u586b\u5199\u7684\u5b57\u6bb5\u503c\u662f\u7a7a\u7684");
        }
        return fieldText;
    }

    public static String[] getBothCheckNodeText(Node node) {
        Node startNode = node.selectSingleNode("attribute::start");
        Node endNode = node.selectSingleNode("attribute::end");
        String startText = XmlNodeHelper.getNodeText(startNode);
        String endText = XmlNodeHelper.getNodeText(endNode);
        if (StringHelper.isBlank(startText) && StringHelper.isBlank(endText)) {
            throw new FieldEmptyException("\u586b\u5199\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u5b57\u6bb5\u503c\u662f\u7a7a\u7684");
        }
        return new String[]{startText, endText};
    }
}

