/*
 * Decompiled with CFR 0.152.
 */
package com.blockchyp.client;

import com.blockchyp.client.APICredentials;
import com.blockchyp.client.PaymentLogger;
import com.blockchyp.client.SystemOutPaymentLogger;
import com.blockchyp.client.TerminalRequest;
import com.blockchyp.client.TerminalRouteResponse;
import com.blockchyp.client.crypto.CryptoUtils;
import com.blockchyp.client.dto.Acknowledgement;
import com.blockchyp.client.dto.AddTestMerchantRequest;
import com.blockchyp.client.dto.AuthorizationRequest;
import com.blockchyp.client.dto.AuthorizationResponse;
import com.blockchyp.client.dto.BalanceRequest;
import com.blockchyp.client.dto.BalanceResponse;
import com.blockchyp.client.dto.BatchDetailsRequest;
import com.blockchyp.client.dto.BatchDetailsResponse;
import com.blockchyp.client.dto.BatchHistoryRequest;
import com.blockchyp.client.dto.BatchHistoryResponse;
import com.blockchyp.client.dto.BooleanPromptRequest;
import com.blockchyp.client.dto.BooleanPromptResponse;
import com.blockchyp.client.dto.BrandingAsset;
import com.blockchyp.client.dto.BrandingAssetRequest;
import com.blockchyp.client.dto.BrandingAssetResponse;
import com.blockchyp.client.dto.CancelPaymentLinkRequest;
import com.blockchyp.client.dto.CancelPaymentLinkResponse;
import com.blockchyp.client.dto.CaptureRequest;
import com.blockchyp.client.dto.CaptureResponse;
import com.blockchyp.client.dto.CaptureSignatureRequest;
import com.blockchyp.client.dto.CaptureSignatureResponse;
import com.blockchyp.client.dto.CashDiscountRequest;
import com.blockchyp.client.dto.CashDiscountResponse;
import com.blockchyp.client.dto.ClearTerminalRequest;
import com.blockchyp.client.dto.CloseBatchRequest;
import com.blockchyp.client.dto.CloseBatchResponse;
import com.blockchyp.client.dto.CustomerRequest;
import com.blockchyp.client.dto.CustomerResponse;
import com.blockchyp.client.dto.CustomerSearchRequest;
import com.blockchyp.client.dto.CustomerSearchResponse;
import com.blockchyp.client.dto.DeleteCustomerRequest;
import com.blockchyp.client.dto.DeleteCustomerResponse;
import com.blockchyp.client.dto.DeleteQueuedTransactionRequest;
import com.blockchyp.client.dto.DeleteQueuedTransactionResponse;
import com.blockchyp.client.dto.DeleteTokenRequest;
import com.blockchyp.client.dto.DeleteTokenResponse;
import com.blockchyp.client.dto.EnrollRequest;
import com.blockchyp.client.dto.EnrollResponse;
import com.blockchyp.client.dto.GetMerchantsRequest;
import com.blockchyp.client.dto.GetMerchantsResponse;
import com.blockchyp.client.dto.GiftActivateRequest;
import com.blockchyp.client.dto.GiftActivateResponse;
import com.blockchyp.client.dto.HeartbeatResponse;
import com.blockchyp.client.dto.ISignatureRequest;
import com.blockchyp.client.dto.ISignatureResponse;
import com.blockchyp.client.dto.ITerminalReference;
import com.blockchyp.client.dto.ITimeoutRequest;
import com.blockchyp.client.dto.InviteMerchantUserRequest;
import com.blockchyp.client.dto.LinkTokenRequest;
import com.blockchyp.client.dto.ListQueuedTransactionsRequest;
import com.blockchyp.client.dto.ListQueuedTransactionsResponse;
import com.blockchyp.client.dto.LocateRequest;
import com.blockchyp.client.dto.LocateResponse;
import com.blockchyp.client.dto.MediaLibraryResponse;
import com.blockchyp.client.dto.MediaMetadata;
import com.blockchyp.client.dto.MediaRequest;
import com.blockchyp.client.dto.MerchantInvoiceDetailRequest;
import com.blockchyp.client.dto.MerchantInvoiceDetailResponse;
import com.blockchyp.client.dto.MerchantInvoiceListRequest;
import com.blockchyp.client.dto.MerchantInvoiceListResponse;
import com.blockchyp.client.dto.MerchantPlatform;
import com.blockchyp.client.dto.MerchantPlatformRequest;
import com.blockchyp.client.dto.MerchantPlatformsResponse;
import com.blockchyp.client.dto.MerchantProfile;
import com.blockchyp.client.dto.MerchantProfileRequest;
import com.blockchyp.client.dto.MerchantProfileResponse;
import com.blockchyp.client.dto.MerchantUsersResponse;
import com.blockchyp.client.dto.MessageRequest;
import com.blockchyp.client.dto.PartnerCommissionBreakdownRequest;
import com.blockchyp.client.dto.PartnerCommissionBreakdownResponse;
import com.blockchyp.client.dto.PartnerStatementDetailRequest;
import com.blockchyp.client.dto.PartnerStatementDetailResponse;
import com.blockchyp.client.dto.PartnerStatementListRequest;
import com.blockchyp.client.dto.PartnerStatementListResponse;
import com.blockchyp.client.dto.PaymentLinkRequest;
import com.blockchyp.client.dto.PaymentLinkResponse;
import com.blockchyp.client.dto.PaymentLinkStatusRequest;
import com.blockchyp.client.dto.PaymentLinkStatusResponse;
import com.blockchyp.client.dto.PingRequest;
import com.blockchyp.client.dto.PingResponse;
import com.blockchyp.client.dto.PricingPolicyRequest;
import com.blockchyp.client.dto.PricingPolicyResponse;
import com.blockchyp.client.dto.RefundRequest;
import com.blockchyp.client.dto.ResendPaymentLinkRequest;
import com.blockchyp.client.dto.ResendPaymentLinkResponse;
import com.blockchyp.client.dto.SlideShow;
import com.blockchyp.client.dto.SlideShowRequest;
import com.blockchyp.client.dto.SlideShowResponse;
import com.blockchyp.client.dto.SurveyQuestion;
import com.blockchyp.client.dto.SurveyQuestionRequest;
import com.blockchyp.client.dto.SurveyQuestionResponse;
import com.blockchyp.client.dto.SurveyResultsRequest;
import com.blockchyp.client.dto.TerminalActivationRequest;
import com.blockchyp.client.dto.TerminalDeactivationRequest;
import com.blockchyp.client.dto.TerminalProfileRequest;
import com.blockchyp.client.dto.TerminalProfileResponse;
import com.blockchyp.client.dto.TerminalStatusRequest;
import com.blockchyp.client.dto.TerminalStatusResponse;
import com.blockchyp.client.dto.TermsAndConditionsLogEntry;
import com.blockchyp.client.dto.TermsAndConditionsLogRequest;
import com.blockchyp.client.dto.TermsAndConditionsLogResponse;
import com.blockchyp.client.dto.TermsAndConditionsRequest;
import com.blockchyp.client.dto.TermsAndConditionsResponse;
import com.blockchyp.client.dto.TermsAndConditionsTemplate;
import com.blockchyp.client.dto.TermsAndConditionsTemplateRequest;
import com.blockchyp.client.dto.TermsAndConditionsTemplateResponse;
import com.blockchyp.client.dto.TextPromptRequest;
import com.blockchyp.client.dto.TextPromptResponse;
import com.blockchyp.client.dto.TokenMetadataRequest;
import com.blockchyp.client.dto.TokenMetadataResponse;
import com.blockchyp.client.dto.TransactionDisplayRequest;
import com.blockchyp.client.dto.TransactionHistoryRequest;
import com.blockchyp.client.dto.TransactionHistoryResponse;
import com.blockchyp.client.dto.TransactionStatusRequest;
import com.blockchyp.client.dto.UnlinkTokenRequest;
import com.blockchyp.client.dto.UpdateCustomerRequest;
import com.blockchyp.client.dto.UploadMetadata;
import com.blockchyp.client.dto.UploadStatus;
import com.blockchyp.client.dto.UploadStatusRequest;
import com.blockchyp.client.dto.VoidRequest;
import com.blockchyp.client.dto.VoidResponse;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.encoders.Hex;

public class BlockChypClient {
    public static final String OFFLINE_CACHE = ".blockchyp_routes";
    public static final String OFFLINE_FIXED_KEY = "cb22789c9d5c344a10e0474f134db39e25eb3bbf5a1b1a5e89b507f15ea9519c";
    public static final long MS_PER_HOUR = 3600000L;
    private static final String USER_AGENT = BlockChypClient.getUserAgent();
    private String gatewayHost = "https://api.blockchyp.com";
    private String testGatewayHost = "https://test.blockchyp.com";
    private String dashboardHost = "https://dashboard.blockchyp.com";
    private APICredentials defaultCredentials;
    private PaymentLogger paymentLogger = new SystemOutPaymentLogger();
    private Map routeCache = new HashMap();
    private boolean offlineRouteCacheEnabled = true;
    private String offlineRouteCacheLocation = null;
    private int connectionTimeout = 0;
    private int timeout = 0;
    private ObjectMapper objectMapper;
    private HttpClient gatewayClient;
    private HttpClient terminalClient;
    private MultiThreadedHttpConnectionManager gatewayManager;
    private MultiThreadedHttpConnectionManager terminalManager;
    private boolean terminalHttps = false;

    public BlockChypClient() {
        this.initObjectMapper();
    }

    public BlockChypClient(String gatewayHost) {
        this();
        this.gatewayHost = gatewayHost;
    }

    public BlockChypClient(APICredentials defaultCredentials) {
        this();
        this.defaultCredentials = defaultCredentials;
    }

    public BlockChypClient(String gatewayHost, APICredentials defaultCredentials) {
        this();
        this.gatewayHost = gatewayHost;
        this.defaultCredentials = defaultCredentials;
    }

    public BlockChypClient(String gatewayHost, String testGatewayHost, APICredentials defaultCredentials) {
        this();
        this.gatewayHost = gatewayHost;
        this.testGatewayHost = testGatewayHost;
        this.defaultCredentials = defaultCredentials;
    }

    public BlockChypClient(String dashboardHost, String gatewayHost, String testGatewayHost, APICredentials defaultCredentials) {
        this();
        this.dashboardHost = dashboardHost;
        this.gatewayHost = gatewayHost;
        this.testGatewayHost = testGatewayHost;
        this.defaultCredentials = defaultCredentials;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public void setDashboardHost(String dashboardHost) {
        this.dashboardHost = dashboardHost;
    }

    public void setTestGatewayHost(String testGatewayHost) {
        this.testGatewayHost = testGatewayHost;
    }

    public void setDefaultCredentials(APICredentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    public void setOfflineRouteCacheEnabled(boolean offlineRouteCacheEnabled) {
        this.offlineRouteCacheEnabled = offlineRouteCacheEnabled;
    }

    public void setPaymentLogger(PaymentLogger paymentLogger) {
        this.paymentLogger = paymentLogger;
    }

    protected void initObjectMapper() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
    }

    public HeartbeatResponse heartbeat(boolean test) throws Exception {
        return (HeartbeatResponse)this.getGateway("/api/heartbeat", test, HeartbeatResponse.class);
    }

    public LocateResponse locate(LocateRequest request) throws Exception {
        return (LocateResponse)this.postGateway("/api/terminal-locate", request, LocateResponse.class);
    }

    public CaptureResponse capture(CaptureRequest request) throws Exception {
        return (CaptureResponse)this.postGateway("/api/capture", request, CaptureResponse.class);
    }

    public VoidResponse voidTx(VoidRequest request) throws Exception {
        return (VoidResponse)this.postGateway("/api/void", request, VoidResponse.class);
    }

    public AuthorizationResponse reverse(AuthorizationRequest request) throws Exception {
        return (AuthorizationResponse)this.postGateway("/api/reverse", request, AuthorizationResponse.class);
    }

    public CloseBatchResponse closeBatch(CloseBatchRequest request) throws Exception {
        return (CloseBatchResponse)this.postGateway("/api/close-batch", request, CloseBatchResponse.class);
    }

    public PaymentLinkResponse sendPaymentLink(PaymentLinkRequest request) throws Exception {
        return (PaymentLinkResponse)this.postGateway("/api/send-payment-link", request, PaymentLinkResponse.class);
    }

    public ResendPaymentLinkResponse resendPaymentLink(ResendPaymentLinkRequest request) throws Exception {
        return (ResendPaymentLinkResponse)this.postGateway("/api/resend-payment-link", request, ResendPaymentLinkResponse.class);
    }

    public CancelPaymentLinkResponse cancelPaymentLink(CancelPaymentLinkRequest request) throws Exception {
        return (CancelPaymentLinkResponse)this.postGateway("/api/cancel-payment-link", request, CancelPaymentLinkResponse.class);
    }

    public PaymentLinkStatusResponse paymentLinkStatus(PaymentLinkStatusRequest request) throws Exception {
        return (PaymentLinkStatusResponse)this.postGateway("/api/payment-link-status", request, PaymentLinkStatusResponse.class);
    }

    public AuthorizationResponse transactionStatus(TransactionStatusRequest request) throws Exception {
        return (AuthorizationResponse)this.postGateway("/api/tx-status", request, AuthorizationResponse.class);
    }

    public CustomerResponse updateCustomer(UpdateCustomerRequest request) throws Exception {
        return (CustomerResponse)this.postGateway("/api/update-customer", request, CustomerResponse.class);
    }

    public CustomerResponse customer(CustomerRequest request) throws Exception {
        return (CustomerResponse)this.postGateway("/api/customer", request, CustomerResponse.class);
    }

    public CustomerSearchResponse customerSearch(CustomerSearchRequest request) throws Exception {
        return (CustomerSearchResponse)this.postGateway("/api/customer-search", request, CustomerSearchResponse.class);
    }

    public CashDiscountResponse cashDiscount(CashDiscountRequest request) throws Exception {
        return (CashDiscountResponse)this.postGateway("/api/cash-discount", request, CashDiscountResponse.class);
    }

    public BatchHistoryResponse batchHistory(BatchHistoryRequest request) throws Exception {
        return (BatchHistoryResponse)this.postGateway("/api/batch-history", request, BatchHistoryResponse.class);
    }

    public BatchDetailsResponse batchDetails(BatchDetailsRequest request) throws Exception {
        return (BatchDetailsResponse)this.postGateway("/api/batch-details", request, BatchDetailsResponse.class);
    }

    public TransactionHistoryResponse transactionHistory(TransactionHistoryRequest request) throws Exception {
        return (TransactionHistoryResponse)this.postGateway("/api/tx-history", request, TransactionHistoryResponse.class);
    }

    public PricingPolicyResponse pricingPolicy(PricingPolicyRequest request) throws Exception {
        return (PricingPolicyResponse)this.postGateway("/api/read-pricing-policy", request, PricingPolicyResponse.class);
    }

    public PartnerStatementListResponse partnerStatements(PartnerStatementListRequest request) throws Exception {
        return (PartnerStatementListResponse)this.postGateway("/api/partner-statement-list", request, PartnerStatementListResponse.class);
    }

    public PartnerStatementDetailResponse partnerStatementDetail(PartnerStatementDetailRequest request) throws Exception {
        return (PartnerStatementDetailResponse)this.postGateway("/api/partner-statement-detail", request, PartnerStatementDetailResponse.class);
    }

    public MerchantInvoiceListResponse merchantInvoices(MerchantInvoiceListRequest request) throws Exception {
        return (MerchantInvoiceListResponse)this.postGateway("/api/merchant-invoice-list", request, MerchantInvoiceListResponse.class);
    }

    public MerchantInvoiceDetailResponse merchantInvoiceDetail(MerchantInvoiceDetailRequest request) throws Exception {
        return (MerchantInvoiceDetailResponse)this.postGateway("/api/merchant-invoice-detail", request, MerchantInvoiceDetailResponse.class);
    }

    public PartnerCommissionBreakdownResponse partnerCommissionBreakdown(PartnerCommissionBreakdownRequest request) throws Exception {
        return (PartnerCommissionBreakdownResponse)this.postGateway("/api/partner-commission-breakdown", request, PartnerCommissionBreakdownResponse.class);
    }

    public MerchantProfileResponse merchantProfile(MerchantProfileRequest request) throws Exception {
        return (MerchantProfileResponse)this.postGateway("/api/public-merchant-profile", request, MerchantProfileResponse.class);
    }

    public DeleteCustomerResponse deleteCustomer(DeleteCustomerRequest request) throws Exception {
        return (DeleteCustomerResponse)this.deleteGateway("/api/customer/" + request.getCustomerId(), request, DeleteCustomerResponse.class);
    }

    public TokenMetadataResponse tokenMetadata(TokenMetadataRequest request) throws Exception {
        return (TokenMetadataResponse)this.getGateway("/api/token/" + request.getToken(), request.isTest(), TokenMetadataResponse.class);
    }

    public Acknowledgement linkToken(LinkTokenRequest request) throws Exception {
        return (Acknowledgement)this.postGateway("/api/link-token", request, Acknowledgement.class);
    }

    public Acknowledgement unlinkToken(UnlinkTokenRequest request) throws Exception {
        return (Acknowledgement)this.postGateway("/api/unlink-token", request, Acknowledgement.class);
    }

    public DeleteTokenResponse deleteToken(DeleteTokenRequest request) throws Exception {
        return (DeleteTokenResponse)this.deleteGateway("/api/token/" + request.getToken(), request, DeleteTokenResponse.class);
    }

    public GetMerchantsResponse getMerchants(GetMerchantsRequest request) throws Exception {
        return (GetMerchantsResponse)this.postDashboard("/api/get-merchants", request, GetMerchantsResponse.class);
    }

    public MerchantProfileResponse updateMerchant(MerchantProfile request) throws Exception {
        return (MerchantProfileResponse)this.postDashboard("/api/update-merchant", request, MerchantProfileResponse.class);
    }

    public MerchantUsersResponse merchantUsers(MerchantProfileRequest request) throws Exception {
        return (MerchantUsersResponse)this.postDashboard("/api/merchant-users", request, MerchantUsersResponse.class);
    }

    public Acknowledgement inviteMerchantUser(InviteMerchantUserRequest request) throws Exception {
        return (Acknowledgement)this.postDashboard("/api/invite-merchant-user", request, Acknowledgement.class);
    }

    public MerchantProfileResponse addTestMerchant(AddTestMerchantRequest request) throws Exception {
        return (MerchantProfileResponse)this.postDashboard("/api/add-test-merchant", request, MerchantProfileResponse.class);
    }

    public Acknowledgement deleteTestMerchant(MerchantProfileRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/test-merchant/" + request.getMerchantId(), request, Acknowledgement.class);
    }

    public MerchantPlatformsResponse merchantPlatforms(MerchantProfileRequest request) throws Exception {
        return (MerchantPlatformsResponse)this.getDashboard("/api/plugin-configs/" + request.getMerchantId(), request, MerchantPlatformsResponse.class);
    }

    public Acknowledgement updateMerchantPlatforms(MerchantPlatform request) throws Exception {
        return (Acknowledgement)this.postDashboard("/api/plugin-configs", request, Acknowledgement.class);
    }

    public Acknowledgement deleteMerchantPlatforms(MerchantPlatformRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/plugin-config/" + request.getPlatformId(), request, Acknowledgement.class);
    }

    public TerminalProfileResponse terminals(TerminalProfileRequest request) throws Exception {
        return (TerminalProfileResponse)this.getDashboard("/api/terminals", request, TerminalProfileResponse.class);
    }

    public Acknowledgement deactivateTerminal(TerminalDeactivationRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/terminal/" + request.getTerminalId(), request, Acknowledgement.class);
    }

    public Acknowledgement activateTerminal(TerminalActivationRequest request) throws Exception {
        return (Acknowledgement)this.postDashboard("/api/terminal-activate", request, Acknowledgement.class);
    }

    public TermsAndConditionsTemplateResponse tcTemplates(TermsAndConditionsTemplateRequest request) throws Exception {
        return (TermsAndConditionsTemplateResponse)this.getDashboard("/api/tc-templates", request, TermsAndConditionsTemplateResponse.class);
    }

    public TermsAndConditionsTemplate tcTemplate(TermsAndConditionsTemplateRequest request) throws Exception {
        return (TermsAndConditionsTemplate)this.getDashboard("/api/tc-templates/" + request.getTemplateId(), request, TermsAndConditionsTemplate.class);
    }

    public TermsAndConditionsTemplate tcUpdateTemplate(TermsAndConditionsTemplate request) throws Exception {
        return (TermsAndConditionsTemplate)this.postDashboard("/api/tc-templates", request, TermsAndConditionsTemplate.class);
    }

    public Acknowledgement tcDeleteTemplate(TermsAndConditionsTemplateRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/tc-templates/" + request.getTemplateId(), request, Acknowledgement.class);
    }

    public TermsAndConditionsLogResponse tcLog(TermsAndConditionsLogRequest request) throws Exception {
        return (TermsAndConditionsLogResponse)this.postDashboard("/api/tc-log", request, TermsAndConditionsLogResponse.class);
    }

    public TermsAndConditionsLogEntry tcEntry(TermsAndConditionsLogRequest request) throws Exception {
        return (TermsAndConditionsLogEntry)this.getDashboard("/api/tc-entry/" + request.getLogEntryId(), request, TermsAndConditionsLogEntry.class);
    }

    public SurveyQuestionResponse surveyQuestions(SurveyQuestionRequest request) throws Exception {
        return (SurveyQuestionResponse)this.getDashboard("/api/survey-questions", request, SurveyQuestionResponse.class);
    }

    public SurveyQuestion surveyQuestion(SurveyQuestionRequest request) throws Exception {
        return (SurveyQuestion)this.getDashboard("/api/survey-questions/" + request.getQuestionId(), request, SurveyQuestion.class);
    }

    public SurveyQuestion updateSurveyQuestion(SurveyQuestion request) throws Exception {
        return (SurveyQuestion)this.postDashboard("/api/survey-questions", request, SurveyQuestion.class);
    }

    public Acknowledgement deleteSurveyQuestion(SurveyQuestionRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/survey-questions/" + request.getQuestionId(), request, Acknowledgement.class);
    }

    public SurveyQuestion surveyResults(SurveyResultsRequest request) throws Exception {
        return (SurveyQuestion)this.postDashboard("/api/survey-results", request, SurveyQuestion.class);
    }

    public MediaLibraryResponse media(MediaRequest request) throws Exception {
        return (MediaLibraryResponse)this.getDashboard("/api/media", request, MediaLibraryResponse.class);
    }

    public MediaMetadata uploadMedia(UploadMetadata request, InputStream inStream) throws Exception {
        return (MediaMetadata)this.postUpload("/api/upload-media", request, inStream, MediaMetadata.class);
    }

    public UploadStatus uploadStatus(UploadStatusRequest request) throws Exception {
        return (UploadStatus)this.getDashboard("/api/media-upload/" + request.getUploadId(), request, UploadStatus.class);
    }

    public MediaMetadata mediaAsset(MediaRequest request) throws Exception {
        return (MediaMetadata)this.getDashboard("/api/media/" + request.getMediaId(), request, MediaMetadata.class);
    }

    public Acknowledgement deleteMediaAsset(MediaRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/media/" + request.getMediaId(), request, Acknowledgement.class);
    }

    public SlideShowResponse slideShows(SlideShowRequest request) throws Exception {
        return (SlideShowResponse)this.getDashboard("/api/slide-shows", request, SlideShowResponse.class);
    }

    public SlideShow slideShow(SlideShowRequest request) throws Exception {
        return (SlideShow)this.getDashboard("/api/slide-shows/" + request.getSlideShowId(), request, SlideShow.class);
    }

    public SlideShow updateSlideShow(SlideShow request) throws Exception {
        return (SlideShow)this.postDashboard("/api/slide-shows", request, SlideShow.class);
    }

    public Acknowledgement deleteSlideShow(SlideShowRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/slide-shows/" + request.getSlideShowId(), request, Acknowledgement.class);
    }

    public BrandingAssetResponse terminalBranding(BrandingAssetRequest request) throws Exception {
        return (BrandingAssetResponse)this.getDashboard("/api/terminal-branding", request, BrandingAssetResponse.class);
    }

    public BrandingAsset updateBrandingAsset(BrandingAsset request) throws Exception {
        return (BrandingAsset)this.postDashboard("/api/terminal-branding", request, BrandingAsset.class);
    }

    public Acknowledgement deleteBrandingAsset(BrandingAssetRequest request) throws Exception {
        return (Acknowledgement)this.deleteDashboard("/api/terminal-branding/" + request.getAssetId(), request, Acknowledgement.class);
    }

    public PingResponse ping(PingRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (PingResponse)this.postTerminal("/api/test", request, PingResponse.class);
        }
        return (PingResponse)this.postGateway("/api/terminal-test", request, PingResponse.class);
    }

    public AuthorizationResponse charge(AuthorizationRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (AuthorizationResponse)this.postTerminal("/api/charge", request, AuthorizationResponse.class);
        }
        return (AuthorizationResponse)this.postGateway("/api/charge", request, AuthorizationResponse.class);
    }

    public AuthorizationResponse preauth(AuthorizationRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (AuthorizationResponse)this.postTerminal("/api/preauth", request, AuthorizationResponse.class);
        }
        return (AuthorizationResponse)this.postGateway("/api/preauth", request, AuthorizationResponse.class);
    }

    public AuthorizationResponse refund(RefundRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (AuthorizationResponse)this.postTerminal("/api/refund", request, AuthorizationResponse.class);
        }
        return (AuthorizationResponse)this.postGateway("/api/refund", request, AuthorizationResponse.class);
    }

    public EnrollResponse enroll(EnrollRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (EnrollResponse)this.postTerminal("/api/enroll", request, EnrollResponse.class);
        }
        return (EnrollResponse)this.postGateway("/api/enroll", request, EnrollResponse.class);
    }

    public GiftActivateResponse giftActivate(GiftActivateRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (GiftActivateResponse)this.postTerminal("/api/gift-activate", request, GiftActivateResponse.class);
        }
        return (GiftActivateResponse)this.postGateway("/api/gift-activate", request, GiftActivateResponse.class);
    }

    public BalanceResponse balance(BalanceRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (BalanceResponse)this.postTerminal("/api/balance", request, BalanceResponse.class);
        }
        return (BalanceResponse)this.postGateway("/api/balance", request, BalanceResponse.class);
    }

    public Acknowledgement clear(ClearTerminalRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (Acknowledgement)this.postTerminal("/api/clear", request, Acknowledgement.class);
        }
        return (Acknowledgement)this.postGateway("/api/terminal-clear", request, Acknowledgement.class);
    }

    public TerminalStatusResponse terminalStatus(TerminalStatusRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (TerminalStatusResponse)this.postTerminal("/api/terminal-status", request, TerminalStatusResponse.class);
        }
        return (TerminalStatusResponse)this.postGateway("/api/terminal-status", request, TerminalStatusResponse.class);
    }

    public TermsAndConditionsResponse termsAndConditions(TermsAndConditionsRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (TermsAndConditionsResponse)this.postTerminal("/api/tc", request, TermsAndConditionsResponse.class);
        }
        return (TermsAndConditionsResponse)this.postGateway("/api/terminal-tc", request, TermsAndConditionsResponse.class);
    }

    public CaptureSignatureResponse captureSignature(CaptureSignatureRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (CaptureSignatureResponse)this.postTerminal("/api/capture-signature", request, CaptureSignatureResponse.class);
        }
        return (CaptureSignatureResponse)this.postGateway("/api/capture-signature", request, CaptureSignatureResponse.class);
    }

    public Acknowledgement newTransactionDisplay(TransactionDisplayRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (Acknowledgement)this.postTerminal("/api/txdisplay", request, Acknowledgement.class);
        }
        return (Acknowledgement)this.postGateway("/api/terminal-txdisplay", request, Acknowledgement.class);
    }

    public Acknowledgement updateTransactionDisplay(TransactionDisplayRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (Acknowledgement)this.putTerminal("/api/txdisplay", request, Acknowledgement.class);
        }
        return (Acknowledgement)this.putGateway("/api/terminal-txdisplay", request, Acknowledgement.class);
    }

    public Acknowledgement message(MessageRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (Acknowledgement)this.postTerminal("/api/message", request, Acknowledgement.class);
        }
        return (Acknowledgement)this.postGateway("/api/message", request, Acknowledgement.class);
    }

    public BooleanPromptResponse booleanPrompt(BooleanPromptRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (BooleanPromptResponse)this.postTerminal("/api/boolean-prompt", request, BooleanPromptResponse.class);
        }
        return (BooleanPromptResponse)this.postGateway("/api/boolean-prompt", request, BooleanPromptResponse.class);
    }

    public TextPromptResponse textPrompt(TextPromptRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (TextPromptResponse)this.postTerminal("/api/text-prompt", request, TextPromptResponse.class);
        }
        return (TextPromptResponse)this.postGateway("/api/text-prompt", request, TextPromptResponse.class);
    }

    public ListQueuedTransactionsResponse listQueuedTransactions(ListQueuedTransactionsRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (ListQueuedTransactionsResponse)this.postTerminal("/api/queue/list", request, ListQueuedTransactionsResponse.class);
        }
        return (ListQueuedTransactionsResponse)this.postGateway("/api/queue/list", request, ListQueuedTransactionsResponse.class);
    }

    public DeleteQueuedTransactionResponse deleteQueuedTransaction(DeleteQueuedTransactionRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (DeleteQueuedTransactionResponse)this.postTerminal("/api/queue/delete", request, DeleteQueuedTransactionResponse.class);
        }
        return (DeleteQueuedTransactionResponse)this.postGateway("/api/queue/delete", request, DeleteQueuedTransactionResponse.class);
    }

    public Acknowledgement reboot(PingRequest request) throws Exception {
        if (this.isTerminalRouted(request)) {
            return (Acknowledgement)this.postTerminal("/api/reboot", request, Acknowledgement.class);
        }
        return (Acknowledgement)this.postGateway("/api/terminal-reboot", request, Acknowledgement.class);
    }

    protected APICredentials decrypt(APICredentials creds) {
        CryptoUtils crypto = CryptoUtils.getInstance();
        APICredentials results = new APICredentials();
        byte[] key = this.deriveOfflineKey();
        try {
            results.setApiKey(crypto.decrypt(creds.getApiKey(), key));
            results.setBearerToken(crypto.decrypt(creds.getBearerToken(), key));
            results.setSigningKey(crypto.decrypt(creds.getSigningKey(), key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    protected APICredentials encrypt(APICredentials creds) {
        CryptoUtils crypto = CryptoUtils.getInstance();
        APICredentials results = new APICredentials();
        byte[] key = this.deriveOfflineKey();
        try {
            results.setApiKey(crypto.encrypt(creds.getApiKey(), key));
            results.setBearerToken(crypto.encrypt(creds.getBearerToken(), key));
            results.setSigningKey(crypto.encrypt(creds.getSigningKey(), key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    protected byte[] deriveOfflineKey() {
        MessageDigest md = DigestUtils.getSha1Digest();
        md.digest(Hex.decode((String)OFFLINE_FIXED_KEY));
        return Arrays.copyOfRange(md.digest(Hex.decode((String)this.defaultCredentials.getSigningKey())), 0, 16);
    }

    protected TerminalRouteResponse routeCacheGet(String terminalName) {
        TerminalRouteResponse route = (TerminalRouteResponse)this.routeCache.get(this.toTerminalRouteKey(terminalName));
        if (route != null) {
            this.paymentLogger.debug("Memory Route Cache Hit: " + terminalName);
            return route;
        }
        if (this.offlineRouteCacheEnabled && (route = this.getOfflineCache(terminalName)) != null) {
            this.routeCachePut(route);
        }
        return route;
    }

    protected void routeCachePut(TerminalRouteResponse route) {
        this.routeCache.put(this.defaultCredentials.getApiKey() + route.getTerminalName(), route);
        if (this.offlineRouteCacheEnabled) {
            try {
                TerminalRouteResponse offlineRoute = (TerminalRouteResponse)BeanUtils.cloneBean((Object)route);
                offlineRoute.setTransientCredentials(this.encrypt(route.getTransientCredentials()));
                File offlineFile = new File(this.resolveOfflineRouteCacheLocation(route.getTerminalName()));
                FileWriter writer = new FileWriter(offlineFile);
                this.objectMapper.writeValue((Writer)writer, (Object)offlineRoute);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String toTerminalRouteKey(String terminalName) {
        return this.defaultCredentials.getApiKey() + terminalName;
    }

    protected void dumpSignatureFile(Object request, Object response) {
        if (request instanceof ISignatureRequest && response instanceof ISignatureResponse) {
            ISignatureRequest sigRequest = (ISignatureRequest)request;
            ISignatureResponse sigResponse = (ISignatureResponse)response;
            if (StringUtils.isEmpty((String)sigResponse.getSigFile())) {
                return;
            }
            if (StringUtils.isEmpty((String)sigRequest.getSigFile())) {
                return;
            }
            try {
                byte[] sigBinary = Hex.decode((String)sigResponse.getSigFile());
                FileUtils.writeByteArrayToFile((File)new File(sigRequest.getSigFile()), (byte[])sigBinary);
            }
            catch (Exception e) {
                this.paymentLogger.error("Exception storing signature file", e);
            }
        }
    }

    protected TerminalRouteResponse resolveTerminalRoute(String terminalName) {
        if (StringUtils.isEmpty((String)terminalName)) {
            return null;
        }
        TerminalRouteResponse route = this.routeCacheGet(terminalName);
        TerminalRouteResponse fallbackRoute = null;
        if (route != null) {
            fallbackRoute = route;
            long expiry = route.getTimestamp().getTime() + 3600000L;
            if (System.currentTimeMillis() > expiry) {
                this.paymentLogger.debug("Ignoring stale route in memory route cache.");
                route = null;
            }
        }
        if (route == null) {
            try {
                route = (TerminalRouteResponse)this.getGateway("/api/terminal-route?terminal=" + URLEncoder.encode(terminalName, "UTF-8"), false, TerminalRouteResponse.class);
                if (route != null) {
                    route.setTimestamp(new Date());
                    this.routeCachePut(route);
                }
            }
            catch (ConnectTimeoutException e) {
                e.printStackTrace();
                return fallbackRoute;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return route;
    }

    protected HttpClient getGatewayClient() {
        if (this.gatewayClient == null) {
            this.gatewayManager = new MultiThreadedHttpConnectionManager();
            this.gatewayClient = new HttpClient((HttpConnectionManager)this.gatewayManager);
            if (this.connectionTimeout > 0) {
                this.gatewayClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
            }
            if (this.timeout > 0) {
                this.gatewayClient.getHttpConnectionManager().getParams().setSoTimeout(this.timeout);
            }
        }
        return this.gatewayClient;
    }

    protected HttpClient getTerminalClient() {
        if (this.terminalClient == null) {
            this.terminalManager = new MultiThreadedHttpConnectionManager();
            this.terminalClient = new HttpClient((HttpConnectionManager)this.terminalManager);
            if (this.connectionTimeout > 0) {
                this.terminalClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
            }
            if (this.timeout > 0) {
                this.terminalClient.getHttpConnectionManager().getParams().setSoTimeout(this.timeout);
            }
        }
        return this.terminalClient;
    }

    protected String resolveTerminalHost(TerminalRouteResponse route) {
        return (this.isTerminalHttps() ? "https://" : "http://") + route.getIpAddress() + (this.isTerminalHttps() ? ":8443" : ":8080");
    }

    protected String toFullyQualifiedTerminalPath(TerminalRouteResponse route, String path) {
        return this.resolveTerminalHost(route) + path;
    }

    protected boolean isTerminalRouted(ITerminalReference terminalName) {
        TerminalRouteResponse route = this.resolveTerminalRoute(terminalName.getTerminalName());
        return StringUtils.isNotEmpty((String)terminalName.getTerminalName()) && !route.isCloudRelayEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object finishTerminalRequest(TerminalRouteResponse route, Object request, HttpMethod method, Class responseType) throws Exception {
        TerminalRequest termRequest = this.newTerminalRequestForRoute(route);
        termRequest.setRequest(request);
        HttpClient client = this.getGatewayClient();
        if (method instanceof EntityEnclosingMethod) {
            StringRequestEntity requestEntity = new StringRequestEntity(this.objectMapper.writeValueAsString((Object)termRequest), "application/json", "UTF-8");
            EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)method;
            entityMethod.setRequestEntity((RequestEntity)requestEntity);
        }
        method.setRequestHeader("User-Agent", USER_AGENT);
        this.paymentLogger.debug("Terminal: " + method.getURI().toString());
        try {
            int status = client.executeMethod(method);
            if (status != 200) {
                throw new IOException(method.getStatusText());
            }
            Object object = this.objectMapper.readValue(method.getResponseBodyAsStream(), responseType);
            return object;
        }
        finally {
            method.releaseConnection();
        }
    }

    protected Object putTerminal(String path, Object request, Class responseType) throws Exception {
        String terminalName = null;
        if (request instanceof ITerminalReference) {
            ITerminalReference ref = (ITerminalReference)request;
            terminalName = ref.getTerminalName();
        }
        TerminalRouteResponse route = this.resolveTerminalRoute(terminalName);
        PutMethod method = new PutMethod(this.resolveTerminalHost(route) + path);
        return this.finishTerminalRequest(route, request, (HttpMethod)method, responseType);
    }

    protected TerminalRequest newTerminalRequestForRoute(TerminalRouteResponse route) {
        TerminalRequest termRequest = new TerminalRequest();
        if (route.getTransientCredentials() != null && StringUtils.isNotEmpty((String)route.getTransientCredentials().getApiKey())) {
            termRequest.setApiKey(route.getTransientCredentials().getApiKey());
            termRequest.setBearerToken(route.getTransientCredentials().getBearerToken());
            termRequest.setSigningKey(route.getTransientCredentials().getSigningKey());
        } else {
            termRequest.setApiKey(this.defaultCredentials.getApiKey());
            termRequest.setBearerToken(this.defaultCredentials.getBearerToken());
            termRequest.setSigningKey(this.defaultCredentials.getSigningKey());
        }
        return termRequest;
    }

    protected Object postTerminal(String path, Object request, Class responseType) throws Exception {
        ITimeoutRequest coreRequest;
        String terminalName = null;
        if (request instanceof ITerminalReference) {
            ITerminalReference ref = (ITerminalReference)request;
            terminalName = ref.getTerminalName();
        }
        TerminalRouteResponse route = this.resolveTerminalRoute(terminalName);
        PostMethod method = new PostMethod(this.resolveTerminalHost(route) + path);
        if (request instanceof ITimeoutRequest && (coreRequest = (ITimeoutRequest)request).getTimeout() > 0) {
            method.getParams().setSoTimeout(coreRequest.getTimeout());
        }
        return this.finishTerminalRequest(route, request, (HttpMethod)method, responseType);
    }

    protected Object getGateway(String path, boolean test, Class responseType) throws Exception {
        return this.getGateway(path, test, responseType, this.timeout);
    }

    protected Object getGateway(String path, boolean test, Class responseType, int requestTimeout) throws Exception {
        GetMethod method = new GetMethod(this.toFullyQualifiedGatewayPath(path, test));
        if (requestTimeout > 0) {
            method.getParams().setSoTimeout(requestTimeout);
        }
        return this.finishGatewayRequest((HttpMethod)method, responseType);
    }

    protected Object getDashboard(String path, ITimeoutRequest request, Class responseType) throws Exception {
        GetMethod method = new GetMethod(this.toFullyQualifiedDashboardPath(path));
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object finishGatewayRequest(HttpMethod method, Class responseType) throws Exception {
        HttpClient client = this.getGatewayClient();
        method.setRequestHeader("User-Agent", USER_AGENT);
        Map<Object, Object> headers = new HashMap();
        if (this.defaultCredentials != null) {
            headers = CryptoUtils.getInstance().generateApiHeaders(this.defaultCredentials.getApiKey(), this.defaultCredentials.getBearerToken(), this.defaultCredentials.getSigningKey());
        }
        this.paymentLogger.debug("Gateway: " + method.getURI().toString());
        for (String string : headers.keySet()) {
            String value = (String)headers.get(string);
            method.addRequestHeader(string, value);
        }
        try {
            int n = client.executeMethod(method);
            if (n == 403) {
                this.paymentLogger.info("Checking clock drift");
            }
            if (n != 200) {
                throw new IOException(method.getStatusText());
            }
            Object object = this.objectMapper.readValue(method.getResponseBodyAsStream(), responseType);
            return object;
        }
        finally {
            method.releaseConnection();
        }
    }

    protected Object postUpload(String path, UploadMetadata request, InputStream inStream, Class responseClass) throws Exception {
        PostMethod method = new PostMethod(this.toFullyQualifiedDashboardPath(path));
        if (request.getFileSize() > 0) {
            method.addRequestHeader("X-File-Size", Integer.toString(request.getFileSize(), 10));
        }
        if (request.getFileName() != null && !request.getFileName().equals("")) {
            method.addRequestHeader("X-Upload-File-Name", request.getFileName());
        }
        if (request.getUploadId() != null && !request.getUploadId().equals("")) {
            method.addRequestHeader("X-Upload-ID", request.getUploadId());
        }
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(inStream);
        method.setRequestEntity((RequestEntity)requestEntity);
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected Object postDashboard(String path, ITimeoutRequest request, Class responseClass) throws Exception {
        PostMethod method = new PostMethod(this.toFullyQualifiedDashboardPath(path));
        StringRequestEntity requestEntity = new StringRequestEntity(this.objectMapper.writeValueAsString((Object)request), "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)requestEntity);
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected Object postGateway(String path, ITimeoutRequest request, Class responseClass) throws Exception {
        PostMethod method = new PostMethod(this.toFullyQualifiedGatewayPath(path, request.isTest()));
        StringRequestEntity requestEntity = new StringRequestEntity(this.objectMapper.writeValueAsString((Object)request), "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)requestEntity);
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected Object putGateway(String path, ITimeoutRequest request, Class responseClass) throws Exception {
        PutMethod method = new PutMethod(this.toFullyQualifiedGatewayPath(path, request.isTest()));
        StringRequestEntity requestEntity = new StringRequestEntity(this.objectMapper.writeValueAsString((Object)request), "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)requestEntity);
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected Object deleteGateway(String path, ITimeoutRequest request, Class responseClass) throws Exception {
        DeleteMethod method = new DeleteMethod(this.toFullyQualifiedGatewayPath(path, request.isTest()));
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected Object deleteDashboard(String path, ITimeoutRequest request, Class responseClass) throws Exception {
        DeleteMethod method = new DeleteMethod(this.toFullyQualifiedDashboardPath(path));
        if (request.getTimeout() > 0) {
            method.getParams().setSoTimeout(request.getTimeout());
        }
        return this.finishGatewayRequest((HttpMethod)method, responseClass);
    }

    protected String resolveOfflineRouteCacheLocation(String terminalName) {
        if (this.offlineRouteCacheLocation != null) {
            return this.offlineRouteCacheLocation + "_" + StringUtils.replaceChars((String)this.toTerminalRouteKey(terminalName), (String)" ", (String)"_");
        }
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringUtils.endsWith((String)temp, (String)String.valueOf(File.separatorChar))) {
            temp = temp + File.separatorChar;
        }
        return temp + OFFLINE_CACHE + "_" + StringUtils.replaceChars((String)this.toTerminalRouteKey(terminalName), (String)" ", (String)"_");
    }

    public TerminalRouteResponse getOfflineCache(String terminalName) {
        File file = new File(this.resolveOfflineRouteCacheLocation(terminalName));
        this.paymentLogger.debug("Checking Offline Route Cache: " + file.getAbsolutePath());
        if (!file.exists()) {
            this.paymentLogger.debug("Offline Route Cache Miss: " + terminalName);
            return null;
        }
        try {
            TerminalRouteResponse route = (TerminalRouteResponse)this.objectMapper.readValue(file, TerminalRouteResponse.class);
            route.setTransientCredentials(this.decrypt(route.getTransientCredentials()));
            this.paymentLogger.debug("Offline Route Cache Hit: " + terminalName);
            return route;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getOfflineRouteCacheLocation() {
        return this.offlineRouteCacheLocation;
    }

    public void setOfflineRouteCacheLocation(String offlineRouteCacheLocation) {
        this.offlineRouteCacheLocation = offlineRouteCacheLocation;
    }

    protected String toFullyQualifiedGatewayPath(String path, boolean test) {
        if (test) {
            return this.testGatewayHost + path;
        }
        return this.gatewayHost + path;
    }

    protected String toFullyQualifiedDashboardPath(String path) {
        return this.dashboardHost + path;
    }

    public boolean isTerminalHttps() {
        return this.terminalHttps;
    }

    public void setTerminalHttps(boolean terminalHttps) {
        this.terminalHttps = terminalHttps;
    }

    private static String getUserAgent() {
        String version = BlockChypClient.class.getPackage().getSpecificationVersion();
        return String.format("BlockChyp-Java/%s", version);
    }
}

