/*
 * Copyright 2013-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package groovy.stream.functions ;

/**
 * Describes a function which takes one value of type {@code T} and another of type {@code U}
 * and transforms them to one of type {@code S}
 *
 * @author Tim Yates
 * @since 0.8
 * @param <T> The first input type
 * @param <U> The second input type
 * @param <S> The output type
 */
public interface Function2<T,U,S> {
    S call( T value, U value2 ) ;
}