/*
 * Copyright 2013-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package groovy.stream.iterators.java ;

import groovy.stream.functions.Predicate ;
import groovy.stream.iterators.groovy.FilteringIterator ;

import java.util.Iterator ;

public class FilteringIteratorForPredicate<T> extends FilteringIterator<T> {
    private final Predicate<T> predicateFn ;

    public FilteringIteratorForPredicate( Iterator<T> iterator, Predicate<T> predicate ) {
        super( iterator, null, false ) ;
        this.predicateFn = predicate ;
    }

    @Override
    protected void setDelegate() {
        // Cannot set delegate
    }

    @Override
    protected boolean callFilter() {
        return predicateFn.call( current ) ;
    }
}