/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream;

import groovy.lang.Closure;
import groovy.stream.functions.Function;
import groovy.stream.functions.Function2;
import groovy.stream.functions.IndexedFunction;
import groovy.stream.functions.IndexedFunction2;
import groovy.stream.functions.IndexedPredicate;
import groovy.stream.functions.Predicate;
import groovy.stream.iterators.BufferedReaderIterator;
import groovy.stream.iterators.CollatingIterator;
import groovy.stream.iterators.ConcatenationIterator;
import groovy.stream.iterators.EnumerationIterator;
import groovy.stream.iterators.LimitedIterator;
import groovy.stream.iterators.MapIterator;
import groovy.stream.iterators.RepeatingClosureIterator;
import groovy.stream.iterators.RepeatingIterator;
import groovy.stream.iterators.RepeatingObjectIterator;
import groovy.stream.iterators.SkipIterator;
import groovy.stream.iterators.groovy.FilteringIterator;
import groovy.stream.iterators.groovy.FlatMapIterator;
import groovy.stream.iterators.groovy.TapIterator;
import groovy.stream.iterators.groovy.TransformingIterator;
import groovy.stream.iterators.groovy.UntilIterator;
import groovy.stream.iterators.groovy.ZipIterator;
import groovy.stream.iterators.java.FilteringIteratorForIndexedPredicate;
import groovy.stream.iterators.java.FilteringIteratorForPredicate;
import groovy.stream.iterators.java.FlatMapIteratorForFunction;
import groovy.stream.iterators.java.FlatMapIteratorForIndexedFunction;
import groovy.stream.iterators.java.TapIteratorForFunction;
import groovy.stream.iterators.java.TapIteratorForIndexedFunction;
import groovy.stream.iterators.java.TransformingIteratorForFunction;
import groovy.stream.iterators.java.TransformingIteratorForIndexedFunction;
import groovy.stream.iterators.java.UntilIteratorForIndexedPredicate;
import groovy.stream.iterators.java.UntilIteratorForPredicate;
import groovy.stream.iterators.java.ZipIteratorForFunction;
import groovy.stream.iterators.java.ZipIteratorForIndexedFunction;
import java.io.BufferedReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Stream<T>
implements Iterator<T> {
    private final Iterator<T> iterator;

    private Stream(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public Stream<T> filter(Closure<Boolean> predicate) {
        return new Stream<T>(new FilteringIterator<T>(this.iterator, predicate, false));
    }

    public Stream<T> filter(Predicate<T> predicate) {
        return new Stream<T>(new FilteringIteratorForPredicate<T>(this.iterator, predicate));
    }

    public Stream<T> filterWithIndex(Closure<Boolean> predicate) {
        return new Stream<T>(new FilteringIterator<T>(this.iterator, predicate, true));
    }

    public Stream<T> filterWithIndex(IndexedPredicate<T> predicate) {
        return new Stream<T>(new FilteringIteratorForIndexedPredicate<T>(this.iterator, predicate));
    }

    public Stream<T> concat(Iterator<? extends T> other) {
        return new Stream<T>(new ConcatenationIterator<T>(this.iterator, other));
    }

    public Stream<T> skip(int n) {
        return new Stream<T>(new SkipIterator<T>(this.iterator, n));
    }

    public <U> Stream<U> flatMap(Closure<? extends Collection<U>> map) {
        return new Stream<T>(new FlatMapIterator(this.iterator, map, false));
    }

    public <U> Stream<U> flatMap(Function<T, ? extends Collection<U>> map) {
        return new Stream<T>(new FlatMapIteratorForFunction(this.iterator, map));
    }

    public <U> Stream<U> flatMapWithIndex(Closure<? extends Collection<U>> map) {
        return new Stream<T>(new FlatMapIterator(this.iterator, map, true));
    }

    public <U> Stream<U> flatMapWithIndex(IndexedFunction<T, ? extends Collection<U>> map) {
        return new Stream<T>(new FlatMapIteratorForIndexedFunction(this.iterator, map));
    }

    public Stream<T> tap(Closure<Void> output) {
        return this.tapEvery(1, output);
    }

    public Stream<T> tap(Function<T, Void> output) {
        return this.tapEvery(1, output);
    }

    public Stream<T> tapEvery(int n, Closure<Void> output) {
        return new Stream<T>(new TapIterator<T>(this.iterator, n, false, output));
    }

    public Stream<T> tapEvery(int n, Function<T, Void> output) {
        return new Stream<T>(new TapIteratorForFunction<T>(this.iterator, n, output));
    }

    public Stream<T> tapWithIndex(Closure<Void> output) {
        return this.tapEveryWithIndex(1, output);
    }

    public Stream<T> tapWithIndex(IndexedFunction<T, Void> output) {
        return this.tapEveryWithIndex(1, output);
    }

    public Stream<T> tapEveryWithIndex(int n, Closure<Void> output) {
        return new Stream<T>(new TapIterator<T>(this.iterator, n, true, output));
    }

    public Stream<T> tapEveryWithIndex(int n, IndexedFunction<T, Void> output) {
        return new Stream<T>(new TapIteratorForIndexedFunction<T>(this.iterator, n, output));
    }

    public <U> Stream<U> map(Closure<U> map) {
        return new Stream<T>(new TransformingIterator<T, U>(this.iterator, map, false));
    }

    public <U> Stream<U> map(Function<T, U> map) {
        return new Stream<T>(new TransformingIteratorForFunction<T, U>(this.iterator, map));
    }

    public <U> Stream<U> mapWithIndex(Closure<U> map) {
        return new Stream<T>(new TransformingIterator<T, U>(this.iterator, map, true));
    }

    public <U> Stream<U> mapWithIndex(IndexedFunction<T, U> map) {
        return new Stream<T>(new TransformingIteratorForIndexedFunction<T, U>(this.iterator, map));
    }

    public Stream<T> until(Closure<Boolean> predicate) {
        return new Stream<T>(new UntilIterator<T>(this.iterator, predicate, false));
    }

    public Stream<T> until(Predicate<T> predicate) {
        return new Stream<T>(new UntilIteratorForPredicate<T>(this.iterator, predicate));
    }

    public Stream<T> untilWithIndex(Closure<Boolean> predicate) {
        return new Stream<T>(new UntilIterator<T>(this.iterator, predicate, true));
    }

    public Stream<T> untilWithIndex(IndexedPredicate<T> predicate) {
        return new Stream<T>(new UntilIteratorForIndexedPredicate<T>(this.iterator, predicate));
    }

    public Stream<Collection<T>> collate(int size) {
        return this.collate(size, size, true);
    }

    public Stream<Collection<T>> collate(int size, boolean keepRemainder) {
        return this.collate(size, size, keepRemainder);
    }

    public Stream<Collection<T>> collate(int size, int step) {
        return this.collate(size, step, true);
    }

    public Stream<Collection<T>> collate(int size, int step, boolean keepRemainder) {
        return new Stream<Collection<T>>(new CollatingIterator<T>(this.iterator, size, step, keepRemainder));
    }

    public <U, V> Stream<V> zip(Iterator<U> other, Closure<V> map) {
        return new Stream<T>(new ZipIterator<T, U, V>(this.iterator, other, false, map));
    }

    public <U, V> Stream<V> zip(Iterable<U> other, Closure<V> map) {
        return new Stream<T>(new ZipIterator<T, U, V>(this.iterator, other.iterator(), false, map));
    }

    public <U, V> Stream<V> zip(Iterator<U> other, Function2<T, U, V> map) {
        return new Stream<T>(new ZipIteratorForFunction<T, U, V>(this.iterator, other, map));
    }

    public <U, V> Stream<V> zip(Iterable<U> other, Function2<T, U, V> map) {
        return new Stream<T>(new ZipIteratorForFunction<T, U, V>(this.iterator, other.iterator(), map));
    }

    public <U, V> Stream<V> zipWithIndex(Iterator<U> other, Closure<V> map) {
        return new Stream<T>(new ZipIterator<T, U, V>(this.iterator, other, true, map));
    }

    public <U, V> Stream<V> zipWithIndex(Iterable<U> other, Closure<V> map) {
        return new Stream<T>(new ZipIterator<T, U, V>(this.iterator, other.iterator(), true, map));
    }

    public <U, V> Stream<V> zipWithIndex(Iterator<U> other, IndexedFunction2<T, U, V> map) {
        return new Stream<T>(new ZipIteratorForIndexedFunction<T, U, V>(this.iterator, other, map));
    }

    public <U, V> Stream<V> zipWithIndex(Iterable<U> other, IndexedFunction2<T, U, V> map) {
        return new Stream<T>(new ZipIteratorForIndexedFunction<T, U, V>(this.iterator, other.iterator(), map));
    }

    public Stream<T> repeat() {
        return new Stream<T>(new RepeatingIterator<T>(this.iterator));
    }

    public Stream<T> repeat(int count) {
        return new Stream<T>(new RepeatingIterator<T>(this.iterator, count));
    }

    public Stream<T> take(int n) {
        return new Stream<T>(new LimitedIterator<T>(this.iterator, n));
    }

    public static <K, V> Stream<Map<K, V>> from(Map<K, ? extends Iterable<V>> map) {
        return new Stream<Map<K, V>>(new MapIterator(map));
    }

    public static <T> Stream<T> from(Stream<T> stream) {
        return new Stream<T>(stream.iterator);
    }

    public static <T> Stream<T> from(Iterable<T> iterable) {
        return new Stream<T>(iterable.iterator());
    }

    public static <T> Stream<T> from(Iterator<T> iterator) {
        return new Stream<T>(iterator);
    }

    public static Stream<String> from(BufferedReader reader) {
        return new Stream<String>(new BufferedReaderIterator(reader));
    }

    public static Stream<ZipEntry> from(ZipFile file) {
        return new Stream<ZipEntry>(new EnumerationIterator<ZipEntry>(file.entries()));
    }

    public static Stream<JarEntry> from(JarFile file) {
        return new Stream<JarEntry>(new EnumerationIterator<JarEntry>(file.entries()));
    }

    public static <T> Stream<T> from(Closure<T> closure) {
        return new Stream<T>(new RepeatingClosureIterator<T>(closure));
    }

    public static <T> Stream<T> from(T object) {
        return new Stream<T>(new RepeatingObjectIterator<T>(object));
    }

    public static <T> Stream<T> from(T[] array) {
        return new Stream(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Byte> from(byte[] array) {
        return new Stream<Byte>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Character> from(char[] array) {
        return new Stream<Character>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Short> from(short[] array) {
        return new Stream<Short>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Integer> from(int[] array) {
        return new Stream<Integer>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Long> from(long[] array) {
        return new Stream<Long>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Float> from(float[] array) {
        return new Stream<Float>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Double> from(double[] array) {
        return new Stream<Double>(Stream.primitiveArrayToList(array).iterator());
    }

    public static Stream<Boolean> from(boolean[] array) {
        return new Stream<Boolean>(Stream.primitiveArrayToList(array).iterator());
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private static List primitiveArrayToList(Object array) {
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

