/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    protected final Iterator<T> iterator;
    protected T current;
    protected boolean loaded;
    protected boolean exhausted;

    public AbstractIterator(Iterator<T> parentIterator) {
        this.iterator = parentIterator;
        this.loaded = false;
        this.current = null;
        this.exhausted = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract void loadNext();

    @Override
    public boolean hasNext() {
        if (!this.loaded) {
            this.loadNext();
            this.loaded = true;
        }
        return !this.exhausted;
    }

    @Override
    public T next() {
        this.hasNext();
        if (this.exhausted) {
            throw new NoSuchElementException("Iterator has been exhausted and contains no more elements");
        }
        T ret = this.current;
        this.loaded = false;
        return ret;
    }
}

