/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BufferedReaderIterator
implements Iterator<String> {
    private String current;
    private final BufferedReader reader;
    private boolean exhausted;
    private boolean loaded;

    public BufferedReaderIterator(BufferedReader r) {
        this.reader = r;
        this.exhausted = false;
        this.current = null;
        this.loaded = false;
    }

    private void loadNext() {
        try {
            this.current = this.reader.readLine();
            if (this.current == null) {
                this.exhausted = true;
            }
        }
        catch (IOException ex) {
            this.exhausted = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.loaded) {
            this.loadNext();
            this.loaded = true;
        }
        return !this.exhausted;
    }

    @Override
    public String next() {
        this.hasNext();
        if (this.exhausted) {
            throw new NoSuchElementException("BufferedReaderIterator has been exhausted and contains no more elements");
        }
        String ret = this.current;
        this.loaded = false;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported on BufferedReaderIterator");
    }
}

