/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import groovy.stream.iterators.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CollatingIterator<T>
extends AbstractIterator<Collection<T>> {
    private final Queue<Collection<T>> cache = new LinkedList<Collection<T>>();
    private Iterator<T> parent;
    private int size;
    private int step;
    private boolean keepRemainder;
    private int index = 0;

    public CollatingIterator(Iterator<T> parent, int size) {
        this(parent, size, size, true);
    }

    public CollatingIterator(Iterator<T> parent, int size, int step) {
        this(parent, size, step, true);
    }

    public CollatingIterator(Iterator<T> parent, int size, boolean keepRemainder) {
        this(parent, size, size, keepRemainder);
    }

    public CollatingIterator(Iterator<T> parent, int size, int step, boolean keepRemainder) {
        super(null);
        if (size < 1) {
            throw new IllegalArgumentException("Collation size must be > 1");
        }
        if (step < 1) {
            throw new IllegalArgumentException("Step size must be > 1");
        }
        this.parent = parent;
        this.size = size;
        this.step = step;
        this.keepRemainder = keepRemainder;
    }

    private void addElementToEachCachedList(T next) {
        for (Collection collection : this.cache) {
            collection.add(next);
        }
    }

    private boolean isFinished() {
        if (!(this.keepRemainder || this.current != null && ((Collection)this.current).size() >= this.size)) {
            return true;
        }
        return this.current == null && !this.parent.hasNext();
    }

    @Override
    protected void loadNext() {
        while (this.parent.hasNext()) {
            T next = this.parent.next();
            if (this.index % this.step == 0) {
                this.cache.offer(new ArrayList());
            }
            ++this.index;
            this.addElementToEachCachedList(next);
            if (this.cache.peek().size() != this.size) continue;
            break;
        }
        this.current = this.cache.poll();
        if (this.isFinished()) {
            this.exhausted = true;
        }
    }

    @Override
    public Collection<T> next() {
        this.hasNext();
        if (this.exhausted) {
            throw new NoSuchElementException("CollatingIterator has been exhausted and contains no more elements");
        }
        ArrayList ret = new ArrayList((Collection)this.current);
        this.loaded = false;
        return ret;
    }
}

