/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import java.util.Iterator;

public class LimitedIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private int limit;

    public LimitedIterator(Iterator<T> delegate, int limit) {
        this.delegate = delegate;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.limit > 0 && this.delegate.hasNext();
    }

    @Override
    public T next() {
        T ret = this.delegate.next();
        --this.limit;
        return ret;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

