/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import groovy.stream.iterators.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapIterator<T, U>
extends AbstractIterator<Map<T, U>> {
    private final Map<T, Iterable<U>> iterables = new LinkedHashMap<T, Iterable<U>>();
    private final Map<T, Iterator<U>> iterators = new LinkedHashMap<T, Iterator<U>>();
    private final List<T> keys = new ArrayList<T>();

    public MapIterator(Map<T, ? extends Iterable<U>> underlying) {
        super(null);
        for (Map.Entry<T, Iterable<U>> entry : underlying.entrySet()) {
            this.keys.add(entry.getKey());
            this.iterables.put(entry.getKey(), entry.getValue());
            this.iterators.put(entry.getKey(), entry.getValue().iterator());
        }
    }

    private void loadFirst() {
        this.current = new LinkedHashMap();
        for (T key : this.keys) {
            ((Map)this.current).put(key, this.iterators.get(key).next());
        }
    }

    @Override
    protected void loadNext() {
        if (this.current == null) {
            this.loadFirst();
        } else {
            this.current = new LinkedHashMap((Map)this.current);
            for (int i = this.keys.size() - 1; i >= 0; --i) {
                T key = this.keys.get(i);
                if (this.iterators.get(key).hasNext()) {
                    ((Map)this.current).put(key, this.iterators.get(key).next());
                    break;
                }
                if (i > 0) {
                    this.iterators.put(key, this.iterables.get(key).iterator());
                    ((Map)this.current).put(key, this.iterators.get(key).next());
                    continue;
                }
                this.exhausted = true;
            }
        }
    }
}

