/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators;

import groovy.stream.iterators.EmptyIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class RepeatingIterator<T>
implements Iterator<T> {
    private static final Integer FOREVER = -65536;
    private final Queue<T> queue = new LinkedList<T>();
    private boolean repeating;
    private Integer nRepeats;
    private Iterator<T> current;

    public RepeatingIterator(Iterator<T> parent) {
        this(parent, FOREVER);
    }

    public RepeatingIterator(Iterator<T> parent, Integer nRepeats) {
        if (nRepeats < 0 && !nRepeats.equals(FOREVER)) {
            throw new IllegalArgumentException("Cannot repeat a negative number of times");
        }
        this.nRepeats = nRepeats;
        this.current = nRepeats == 0 ? new EmptyIterator() : parent;
        this.repeating = false;
    }

    @Override
    public boolean hasNext() {
        return this.nRepeats == FOREVER || this.nRepeats > 1 || this.current.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        if (!this.current.hasNext()) {
            if (this.nRepeats != FOREVER) {
                Integer n = this.nRepeats;
                Integer n2 = this.nRepeats = Integer.valueOf(this.nRepeats - 1);
                if (n <= 1) {
                    throw new NoSuchElementException("RepeatingIterator has been exhausted and contains no more elements");
                }
            }
            this.repeating = true;
            this.current = this.queue.iterator();
        }
        T ret = this.current.next();
        if (!this.repeating) {
            this.queue.offer(ret);
        }
        return ret;
    }
}

