/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators.groovy;

import groovy.lang.Closure;
import groovy.stream.iterators.AbstractIterator;
import java.util.Iterator;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class FilteringIterator<T>
extends AbstractIterator<T> {
    private final Closure<Boolean> predicate;
    private final boolean withIndex;
    protected int index = 0;

    public FilteringIterator(Iterator<T> iterator, Closure<Boolean> predicate, boolean withIndex) {
        super(iterator);
        this.predicate = predicate;
        this.withIndex = withIndex;
    }

    @Override
    protected void loadNext() {
        while (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            this.setDelegate();
            Boolean result = this.callFilter();
            ++this.index;
            if (!result.booleanValue()) continue;
            return;
        }
        this.exhausted = true;
    }

    protected boolean callFilter() {
        return this.withIndex ? DefaultTypeTransformation.castToBoolean((Object)this.predicate.call(new Object[]{this.current, this.index})) : DefaultTypeTransformation.castToBoolean((Object)this.predicate.call(this.current));
    }

    protected void setDelegate() {
        this.predicate.setDelegate(this.current);
    }
}

