/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators.groovy;

import groovy.lang.Closure;
import groovy.stream.iterators.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class FlatMapIterator<T, U>
extends AbstractIterator<U> {
    protected final Queue<U> pushback = new LinkedList<U>();
    protected final Iterator<T> inputIterator;
    private final boolean withIndex;
    protected int index = 0;
    private final Closure<? extends Collection<U>> mapping;

    public FlatMapIterator(Iterator<T> iterator, Closure<? extends Collection<U>> mapping, boolean withIndex) {
        super(null);
        this.mapping = mapping;
        this.inputIterator = iterator;
        this.withIndex = withIndex;
    }

    @Override
    protected void loadNext() {
        while (this.pushback.isEmpty() && this.inputIterator.hasNext()) {
            T next = this.inputIterator.next();
            this.setDelegate(next);
            Collection<U> mapped = this.performMapping(next);
            ++this.index;
            for (U element : mapped) {
                this.pushback.offer(element);
            }
        }
        if (!this.pushback.isEmpty()) {
            this.current = this.pushback.poll();
        } else {
            this.exhausted = true;
        }
    }

    protected Collection<U> performMapping(T next) {
        return this.withIndex ? (Collection)this.mapping.call(new Object[]{next, this.index}) : (Collection)this.mapping.call(next);
    }

    protected void setDelegate(T next) {
        this.mapping.setDelegate(next);
    }
}

