/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators.groovy;

import groovy.lang.Closure;
import groovy.stream.iterators.AbstractIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TapIterator<T>
extends AbstractIterator<T> {
    protected final int every;
    private final boolean withIndex;
    private final Closure<Void> output;
    protected int index;

    public TapIterator(Iterator<T> parent, int every, boolean withIndex, Closure<Void> output) {
        super(parent);
        this.every = every;
        this.index = 0;
        this.withIndex = withIndex;
        this.output = output;
    }

    @Override
    protected void loadNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
        } else {
            this.exhausted = true;
        }
    }

    @Override
    public T next() {
        this.hasNext();
        if (this.exhausted) {
            throw new NoSuchElementException("TapIterator has been exhausted and contains no more elements");
        }
        Object ret = this.current;
        this.performTap(ret);
        this.loaded = false;
        return (T)ret;
    }

    protected void performTap(T ret) {
        if (++this.index % this.every == 0) {
            if (this.withIndex) {
                this.output.call(new Object[]{ret, this.index - 1});
            } else {
                this.output.call(ret);
            }
        }
    }
}

