/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators.groovy;

import groovy.lang.Closure;
import groovy.stream.iterators.AbstractIterator;
import java.util.Iterator;

public class TransformingIterator<T, U>
extends AbstractIterator<U> {
    protected final Iterator<T> inputIterator;
    private final Closure<U> mapping;
    private final boolean withIndex;
    protected int index = 0;

    public TransformingIterator(Iterator<T> iterator, Closure<U> mapping, boolean withIndex) {
        super(null);
        this.inputIterator = iterator;
        this.mapping = mapping;
        this.withIndex = withIndex;
    }

    @Override
    protected void loadNext() {
        if (this.inputIterator.hasNext()) {
            T next = this.inputIterator.next();
            this.setDelegate(next);
            this.current = this.getMappedValue(next);
            ++this.index;
        } else {
            this.exhausted = true;
        }
    }

    protected void setDelegate(T next) {
        this.mapping.setDelegate(next);
    }

    protected U getMappedValue(T next) {
        return (U)(this.withIndex ? this.mapping.call(new Object[]{next, this.index}) : this.mapping.call(next));
    }
}

