/*
 * Decompiled with CFR 0.152.
 */
package groovy.stream.iterators.groovy;

import groovy.lang.Closure;
import groovy.stream.iterators.AbstractIterator;
import java.util.Iterator;

public class ZipIterator<T, U, V>
extends AbstractIterator<V> {
    protected final Iterator<T> iter1;
    protected final Iterator<U> iter2;
    private final Closure<V> method;
    private final boolean withIndex;
    protected int index;

    public ZipIterator(Iterator<T> iter1, Iterator<U> iter2, boolean withIndex, Closure<V> method) {
        super(null);
        this.iter1 = iter1;
        this.iter2 = iter2;
        this.method = method;
        this.withIndex = withIndex;
        this.loaded = false;
        this.exhausted = false;
        this.index = 0;
    }

    @Override
    protected void loadNext() {
        if (this.iter1.hasNext()) {
            T obj1 = this.iter1.next();
            if (this.iter2.hasNext()) {
                U obj2 = this.iter2.next();
                this.current = this.performZip(obj1, obj2);
                ++this.index;
            } else {
                this.exhausted = true;
            }
        } else {
            this.exhausted = true;
        }
    }

    protected V performZip(T obj1, U obj2) {
        return (V)(this.withIndex ? this.method.call(new Object[]{obj1, obj2, this.index}) : this.method.call(new Object[]{obj1, obj2}));
    }
}

