/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.bridge;

import com.bloock.sdk.ffi.Ffi;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ConnectionRequest<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(ConnectionRequest.class.getName());
    private final MethodDescriptor<ReqT, RespT> method;
    private ClientCall.Listener<RespT> listener;
    private final CallOptions callOptions;

    ConnectionRequest(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        this.method = method;
        this.callOptions = callOptions;
    }

    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
        this.listener = responseListener;
    }

    public void request(int numMessages) {
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
    }

    public void halfClose() {
    }

    public void sendMessage(ReqT message) {
        byte[] payload;
        String requestType = "/" + this.method.getFullMethodName();
        try {
            InputStream stream = this.method.streamRequest(message);
            payload = new byte[stream.available()];
            DataInputStream dataInputStream = new DataInputStream(stream);
            dataInputStream.readFully(payload);
        }
        catch (IOException e) {
            logger.severe(e.toString());
            return;
        }
        byte[] response = Ffi.get().request(requestType, payload);
        ByteArrayInputStream responseStrean = new ByteArrayInputStream(response);
        Object respT = this.method.parseResponse((InputStream)responseStrean);
        this.listener.onMessage(respT);
        this.listener.onClose(Status.OK, null);
    }
}

