/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockAuthenticity;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockKeys;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.authenticity.Signature;
import com.bloock.sdk.entity.authenticity.Signer;
import com.bloock.sdk.entity.key.EcdsaKeyPair;
import com.bloock.sdk.entity.key.KeyType;
import com.bloock.sdk.entity.record.Record;
import java.util.List;
import java.util.stream.Collectors;

public class AuthenticityClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public AuthenticityClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public AuthenticityClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    @Deprecated
    public EcdsaKeyPair generateEcdsaKeyPair() throws Exception {
        BloockKeys.GenerateLocalKeyRequest request = BloockKeys.GenerateLocalKeyRequest.newBuilder().setConfigData(this.configData).setKeyType(KeyType.EcP256k.toProto()).build();
        BloockKeys.GenerateLocalKeyResponse response = this.bridge.getKey().generateLocalKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return EcdsaKeyPair.fromProto(response);
    }

    public Signature sign(Record record, Signer signer) throws Exception {
        BloockAuthenticity.SignRequest request = BloockAuthenticity.SignRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).setSigner(signer.toProto()).build();
        BloockAuthenticity.SignResponse response = this.bridge.getAuthenticity().sign(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Signature.fromProto(response.getSignature());
    }

    public boolean verify(Record record) throws Exception {
        BloockAuthenticity.VerifyRequest request = BloockAuthenticity.VerifyRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).build();
        BloockAuthenticity.VerifyResponse response = this.bridge.getAuthenticity().verify(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return response.getValid();
    }

    public List<Signature> getSignatures(Record record) throws Exception {
        BloockAuthenticity.GetSignaturesRequest req = BloockAuthenticity.GetSignaturesRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).build();
        BloockAuthenticity.GetSignaturesResponse recordSignatures = this.bridge.getAuthenticity().getSignatures(req);
        if (recordSignatures.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(recordSignatures.getError().getMessage());
        }
        return recordSignatures.getSignaturesList().stream().map(x -> Signature.fromProto(x)).collect(Collectors.toList());
    }
}

