/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockAvailability;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.availability.Loader;
import com.bloock.sdk.entity.availability.PublishResponse;
import com.bloock.sdk.entity.availability.Publisher;
import com.bloock.sdk.entity.record.Record;

public class AvailabilityClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public AvailabilityClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public AvailabilityClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    public PublishResponse publish(Record record, Publisher publisher) throws Exception {
        BloockAvailability.PublishRequest req = BloockAvailability.PublishRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).setPublisher(publisher.toProto()).build();
        BloockAvailability.PublishResponse response = this.bridge.getAvailability().publish(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return PublishResponse.fromProto(response);
    }

    public Record retrieve(Loader loader) throws Exception {
        BloockAvailability.RetrieveRequest req = BloockAvailability.RetrieveRequest.newBuilder().setConfigData(this.configData).setLoader(loader.toProto()).build();
        BloockAvailability.RetrieveResponse response = this.bridge.getAvailability().retrieve(req);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Record.fromProto(response.getRecord(), this.configData);
    }
}

