/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.client.AuthenticityClient;
import com.bloock.sdk.client.EncryptionClient;
import com.bloock.sdk.client.IdentityClient;
import com.bloock.sdk.client.IdentityCoreClient;
import com.bloock.sdk.client.IntegrityClient;
import com.bloock.sdk.client.RecordClient;
import com.bloock.sdk.client.WebhookClient;
import com.bloock.sdk.config.Config;

public class BloockClient {
    private BloockConfig.ConfigData configData;
    private final IntegrityClient integrityClient;
    private final AuthenticityClient authenticityClient;
    private final EncryptionClient encryptionClient;
    private final IdentityCoreClient identityCoreClient;
    private final IdentityClient identityClient;
    private final RecordClient recordClient;
    private final WebhookClient webhookClient;

    public BloockClient(String apiKey, String identityApiHost) {
        BloockConfig.ConfigData configData = Config.newConfigDataDefault();
        BloockConfig.Configuration configuration = BloockConfig.Configuration.newBuilder().setApiKey(apiKey).setIdentityApiHost(identityApiHost).build();
        this.configData = BloockConfig.ConfigData.newBuilder().setConfig(configuration).putAllNetworksConfig(configData.getNetworksConfigMap()).build();
        this.integrityClient = new IntegrityClient(this.configData);
        this.authenticityClient = new AuthenticityClient(this.configData);
        this.identityCoreClient = new IdentityCoreClient(this.configData);
        this.identityClient = new IdentityClient(this.configData);
        this.encryptionClient = new EncryptionClient(this.configData);
        this.recordClient = new RecordClient(this.configData);
        this.webhookClient = new WebhookClient(this.configData);
    }

    public IntegrityClient getIntegrityClient() {
        return this.integrityClient;
    }

    public AuthenticityClient getAuthenticityClient() {
        return this.authenticityClient;
    }

    public EncryptionClient getEncryptionClient() {
        return this.encryptionClient;
    }

    public RecordClient getRecordClient() {
        return this.recordClient;
    }

    public WebhookClient getWebhookClient() {
        return this.webhookClient;
    }

    public IdentityCoreClient getIdentityCoreClient() {
        return this.identityCoreClient;
    }

    public IdentityClient getIdentityClient() {
        return this.identityClient;
    }
}

