/*
 * Decompiled with CFR 0.152.
 */
package com.bloock.sdk.client;

import com.bloock.sdk.bridge.Bridge;
import com.bloock.sdk.bridge.proto.BloockConfig;
import com.bloock.sdk.bridge.proto.BloockEncryption;
import com.bloock.sdk.bridge.proto.BloockKeys;
import com.bloock.sdk.bridge.proto.BloockShared;
import com.bloock.sdk.config.Config;
import com.bloock.sdk.entity.encryption.Encrypter;
import com.bloock.sdk.entity.encryption.EncryptionAlg;
import com.bloock.sdk.entity.key.KeyType;
import com.bloock.sdk.entity.key.RsaKeyPair;
import com.bloock.sdk.entity.record.Record;

public class EncryptionClient {
    private final Bridge bridge = new Bridge();
    private final BloockConfig.ConfigData configData;

    public EncryptionClient() {
        this.configData = Config.newConfigDataDefault();
    }

    public EncryptionClient(BloockConfig.ConfigData configData) {
        this.configData = Config.newConfigData(configData);
    }

    @Deprecated
    public RsaKeyPair generateRsaKeyPair() throws Exception {
        BloockKeys.GenerateLocalKeyRequest request = BloockKeys.GenerateLocalKeyRequest.newBuilder().setConfigData(this.configData).setKeyType(KeyType.Rsa2048.toProto()).build();
        BloockKeys.GenerateLocalKeyResponse response = this.bridge.getKey().generateLocalKey(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return RsaKeyPair.fromProto(response);
    }

    public Record encrypt(Record record, Encrypter encrypter) throws Exception {
        BloockEncryption.EncryptRequest request = BloockEncryption.EncryptRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).setEncrypter(encrypter.toProto()).build();
        BloockEncryption.EncryptResponse response = this.bridge.getEncryption().encrypt(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Record.fromProto(response.getRecord(), this.configData);
    }

    public Record decrypt(Record record, Encrypter decrypter) throws Exception {
        BloockEncryption.DecryptRequest request = BloockEncryption.DecryptRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).setDecrypter(decrypter.toProto()).build();
        BloockEncryption.DecryptResponse response = this.bridge.getEncryption().decrypt(request);
        if (response.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(response.getError().getMessage());
        }
        return Record.fromProto(response.getRecord(), this.configData);
    }

    public EncryptionAlg getEncryptionAlg(Record record) throws Exception {
        Bridge bridge = new Bridge();
        BloockEncryption.EncryptionAlgRequest req = BloockEncryption.EncryptionAlgRequest.newBuilder().setConfigData(this.configData).setRecord(record.toProto()).build();
        BloockEncryption.EncryptionAlgResponse res = bridge.getEncryption().getEncryptionAlg(req);
        if (res.getError() != BloockShared.Error.getDefaultInstance()) {
            throw new Exception(res.getError().getMessage());
        }
        return EncryptionAlg.fromProto(res.getAlg());
    }
}

